package com.hx.lib_common.log;

import android.util.Log;

import com.hx.lib_common.utils.FileUtils;
import com.hx.lib_common.utils.TaskUtils;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import de.mindpipe.android.logging.log4j.LogConfigurator;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/5/27 17:00
 * Describe:
 */
public abstract class IFileLogConfig {
    private static final int MAX_FILE_SIZE = 20;    //保留最大文件个数
    protected final String TAG = getClass().getSimpleName();


    protected final String logFileDir;
    private int maxFileSize = MAX_FILE_SIZE;


    public IFileLogConfig(final String logFileDir){
        this.logFileDir = logFileDir;
    }

    /**
     * 保留的最大文件个数
     * @param size
     * @return
     */
    public IFileLogConfig setMaxFileSize(int size){
        maxFileSize = size;
        return this;
    }

    public abstract void onConfig(LogConfigurator logConfigurator);

    public void initConfig(){
        if (logFileDir == null) {
            return;
        }
        try {
            LogConfigurator logConfigurator = new LogConfigurator();
            onConfig(logConfigurator);
            logConfigurator.configure();
            if (maxFileSize > 0) {
                TaskUtils.runAsync(new TaskUtils.Task() {
                    @Override
                    public void run() {
                        deleteLogFile(logFileDir);
                    }
                });
            }
        } catch (Exception e) {
        }
    }

    private void deleteLogFile(String fileLogDir){
        File file = new File(fileLogDir);
        if (file.isDirectory()){
            String[] files = file.list();
            if (files != null && files.length > maxFileSize){
                List<String> fileList = Arrays.asList(files);
                Collections.sort(fileList, new Comparator<String>() {
                    @Override
                    public int compare(String o1, String o2) {  //升序
                        return o2.compareTo(o1);
                    }
                });
                for (int i = maxFileSize; i < fileList.size(); i++) {
                    Log.i(TAG, "delete log file: " + fileList.get(i));
                    FileUtils.delete(new File(fileLogDir, fileList.get(i)));
                }
            }
        }
    }
}
