package com.hx.lib_common.log;

import android.text.TextUtils;
import android.util.Log;

import org.apache.log4j.Logger;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/5/27 14:33
 * Describe:
 * 日记记录
 */
public class HLog {

    public static void i(String tag, String msg){
        if (HLogConfig.getInstance().getAndroidLogEnable()) {
            Log.i(tag, msg);
        }
        if (HLogConfig.getInstance().getFileLogEnable()){
            getLogger(tag).info(msg);
        }
    }

    public static void d(String tag, String msg){
        if (HLogConfig.getInstance().getAndroidLogEnable()) {
            Log.d(tag, msg);
        }
        if (HLogConfig.getInstance().getFileLogEnable()){
            getLogger(tag).debug(msg);
        }
    }

    public static void w(String tag, String msg){
        if (HLogConfig.getInstance().getAndroidLogEnable()) {
            Log.w(tag, msg);
        }
        if (HLogConfig.getInstance().getFileLogEnable()){
            getLogger(tag).warn(msg);
        }
    }

    public static void e(String tag, String msg){
        if (HLogConfig.getInstance().getAndroidLogEnable()) {
            Log.e(tag, msg);
        }
        if (HLogConfig.getInstance().getFileLogEnable()){
            getLogger(tag).error(msg);
        }
    }

    private static Logger getLogger(String tag) {
        Logger logger;
        if (TextUtils.isEmpty(tag)) {
            logger = Logger.getRootLogger();
        } else {
            logger = Logger.getLogger(tag);
        }
        return logger;
    }
}
