package com.hx.lib_common.log;

import android.util.Log;

import com.hx.lib_common.utils.FileUtils;
import com.hx.lib_common.utils.TaskUtils;

import org.apache.log4j.Level;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import de.mindpipe.android.logging.log4j.LogConfigurator;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/5/27 14:53
 * Describe:
 */
public class DefaultFileLogConfig extends IFileLogConfig {


    public DefaultFileLogConfig(String logFileDir) {
        super(logFileDir);
    }

    @Override
    public void onConfig(LogConfigurator logConfigurator) {
        logConfigurator.setRootLevel(Level.DEBUG);
        logConfigurator.setLevel("org.apache", Level.ERROR);
        logConfigurator.setFilePattern("%d{yyyy-MM-dd HH:mm:ss.SSS} (%t) [%c{2}.%L]: %m%n");   //前缀
        logConfigurator.setMaxFileSize(1024 * 1024 * 5);    //单个文件大小
        logConfigurator.setMaxBackupSize(5);    //备份文件个数
        logConfigurator.setImmediateFlush(true);

        String time = new SimpleDateFormat("yyyy_MM_dd").format(new Date());
        String fileName = "log_" + time + ".txt";

        logConfigurator.setFileName(logFileDir + File.separator + fileName);
    }

}
