package com.hx.lib_common.log;

import android.os.Environment;
import android.util.Log;

import org.apache.log4j.Level;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

import de.mindpipe.android.logging.log4j.LogConfigurator;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/5/28 9:29
 * Describe:
 * Crash日记配置
 */
public class CrashFileLogConfig extends IFileLogConfig {

    public CrashFileLogConfig(String logFileDir) {
        super(logFileDir);
    }

    @Override
    public void onConfig(LogConfigurator logConfigurator) {
        logConfigurator.setRootLevel(Level.DEBUG);
        logConfigurator.setLevel("org.apache", Level.ERROR);
        logConfigurator.setFilePattern("%d %-5p [%c{2}]-[%L] %m%n");
        logConfigurator.setMaxFileSize(1024 * 1024 * 5);
        logConfigurator.setImmediateFlush(true);

        String time = new SimpleDateFormat("yyyy_MM_dd").format(new Date());
        String fileName = "crash-" + time + ".txt";

        logConfigurator.setFileName(logFileDir + File.separator + fileName);
    }
}
