package com.hx.lib_common.annotation.aspectj;

import android.os.SystemClock;

import com.hx.lib_common.annotation.MultiClick;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/4/22 13:48
 * Describe:
 */
@Aspect
public class MultiClickAspectJ {
    private String lastClickView = null;
    private List<Long> clickViewTime = null;
    /**
     * 过滤指定Annotation标注的函数
     * 并用@annotation(anno)这种方法来告诉 AspectJ，这个anno是一个注解
     */
    @Pointcut("execution(@com.hx.lib_common.annotation.MultiClick * *(..)) && @annotation(anno)")
    public void annotationPointcut(MultiClick anno){}

    @Around("annotationPointcut(anno)")
    public Object aroundPointCut(ProceedingJoinPoint joinPoint, MultiClick anno){
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodKey = signature.toLongString();
        if (!methodKey.equals(lastClickView)){
            lastClickView = methodKey;
            clickViewTime = new ArrayList<>();
        }
        long current = SystemClock.elapsedRealtime();
        clickViewTime.add(current);
        if (clickViewTime.size() >= anno.clickTimes()){
            Iterator<Long> it = clickViewTime.iterator();
            while (it.hasNext()){
                Long next = it.next();
                if (current - next > anno.timeDiff()){
                    it.remove();
                }
            }
            if (clickViewTime.size() >= anno.clickTimes()){
                clickViewTime.clear();
                try {
                    return joinPoint.proceed();
                } catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        return null;
    }
}
