package com.hx.lib_common.utils;

import com.hx.lib_common.constant.RegexConst;

import java.util.regex.Pattern;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/5/13 16:53
 * Describe:
 * 正则表达式判断
 */
public class RegexUtils {


    /**
     * 是否是ip地址
     * @param input
     * @return
     */
    public static boolean isIP(final CharSequence input) {
        return isMatch(RegexConst.REGEX_IP, input);
    }

    /**
     * 是否是ip端口
     * @param port
     * @return
     */
    public static boolean isIpPort(String port) {
        int iPort;
        try {
            iPort = Integer.parseInt(port);
        } catch (Exception e) {
            iPort = 0;
        }
        return !(iPort == 0 || iPort > 65535);
    }

    public static boolean isMatch(final String regex, final CharSequence input) {
        return input != null && input.length() > 0 && Pattern.matches(regex, input);
    }
}
