package com.hx.lib_common.utils;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/4/2 16:56
 * Describe:
 */
public class ProcessUtils {

    private static final String TAG = "ProcessUtils";
    /**
     * 进程是否运行
     * @param context
     * @param processName
     * @return
     */
    public static boolean isProcessExist(Context context, String processName){
        ActivityManager am=(ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningAppProcessInfo> processList = am.getRunningAppProcesses();
        for(ActivityManager.RunningAppProcessInfo info:processList){
            if (processName.equals(info.processName)){
                return true;
            }
        }
        for(ActivityManager.RunningAppProcessInfo info:processList){
            Log.d(TAG, "isProcessExist() called processName = [" + info.processName + "]");
        }
        return false;
    }

    /**
     * 获取自己的进程名
     * @return
     */
    public static String getMyProcessName(Context context) {
        try {
            String processName = (String) new Reflect("android.app.ActivityThread")
                    .invokeMethod("currentProcessName");
            if (!TextUtils.isEmpty(processName)){
                return processName;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        int pid = Process.myPid();
        ActivityManager mActivityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        for (ActivityManager.RunningAppProcessInfo appProcess : mActivityManager.getRunningAppProcesses()) {
            if (appProcess.pid == pid) {
                return appProcess.processName;
            }
        }
        return "";
    }

    /**
     * 当前为主进程
     * @param context
     * @return
     */
    public static boolean isMainProcess(Context context){
        return context.getPackageName().equals(getMyProcessName(context));
    }
}
