package com.hx.lib_common.utils;

import android.app.AlarmManager;
import android.app.Application;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.util.Log;

import java.util.List;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/6/15 9:27
 * Describe:
 */
public class ActivityUtils {
    private static final String TAG = "ActivityUtils";
    /**
     * 打开Activity
     * @param context
     * @param packageName
     * @param className
     * @param bundle
     */
    public static void launchActivity(Context context, String packageName, String className, Bundle bundle) {
        Intent intent = new Intent(Intent.ACTION_VIEW);
        if (bundle != null) intent.putExtras(bundle);
        ComponentName cn = new ComponentName(packageName, className);
        intent.setComponent(cn);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }

    /**
     * 启动自己
     * @param context
     */
    public static void launchStartActivity(Context context) {
        launchActivity(context, context.getPackageName(),
                getLauncherActivity(context), null);
    }

    /**
     * 重启应用
     * @param context
     */
    public static void restartApp(Application context) {
        restartApp(context, 1000);
    }


    /**
     * 重启应用
     * @param context
     * @param millis
     */
    public static void restartApp(Application context, long millis) {
        Log.e(TAG, "restartApp: ");
        String packageName = context.getPackageName();
        String className = getLauncherActivity(context);
        Intent intent = new Intent();
        ComponentName cn = new ComponentName(packageName, className);
        intent.setComponent(cn);
        PendingIntent restartIntent = PendingIntent.getActivity(context,0,intent, PendingIntent.FLAG_CANCEL_CURRENT);
        AlarmManager mgr = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
        mgr.set(AlarmManager.RTC,millis,restartIntent);

        //杀死该应用进程
        android.os.Process.killProcess(android.os.Process.myPid());
    }

    /**
     * 重启主进程应用
     * @param context
     * @param millis
     */
    public static void restartMainApp(Application context, long millis) {
        int mainProcessId = AppUtils.getMainProcessId(context);
        Log.e(TAG, "restartMainApp: " + mainProcessId);
        if (mainProcessId > 0) {
            String packageName = context.getPackageName();
            String className = getLauncherActivity(context);
            Intent intent = new Intent();
            ComponentName cn = new ComponentName(packageName, className);
            intent.setComponent(cn);
            PendingIntent restartIntent = PendingIntent.getActivity(context, 0, intent, PendingIntent.FLAG_CANCEL_CURRENT);
            AlarmManager mgr = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
            mgr.set(AlarmManager.RTC, millis, restartIntent);

            //杀死该应用进程
            android.os.Process.killProcess(mainProcessId);
        }
    }

    private static String getLauncherActivity(Context context) {
        Intent intent = new Intent(Intent.ACTION_MAIN, null);
        intent.addCategory(Intent.CATEGORY_LAUNCHER);
        intent.setPackage(context.getPackageName());
        PackageManager pm = context.getPackageManager();
        List<ResolveInfo> info = pm.queryIntentActivities(intent, 0);
        if (info == null || info.size() == 0) {
            return "";
        }
        return info.get(0).activityInfo.name;
    }
}
