package io.gitee.mrxangel;


import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.TimeUnit;

/**
 * @author 子默
 */
@Configuration
@ComponentScan
@EnableConfigurationProperties(PulsarProperties.class)
public class PulsarAutoConfiguration {

    private final  PulsarProperties pulsarProperties;
    PulsarAutoConfiguration(PulsarProperties pulsarProperties){
       this.pulsarProperties= pulsarProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix = "pulsar",name ="serviceUrl" )
    public PulsarClient pulsarClient() throws PulsarClientException {
        String serviceUrl=pulsarProperties.getServiceUrl();
        if(serviceUrl == null || serviceUrl.length() == 0) {
            return null;
        }
        ClientBuilder clientBuilder=PulsarClient.builder()
                .serviceUrl(pulsarProperties.getServiceUrl())
                .ioThreads(pulsarProperties.getIoThreads())
                .listenerThreads(pulsarProperties.getListenerThreads())
                .enableTcpNoDelay(pulsarProperties.isEnableTcpNoDelay())
                .keepAliveInterval(pulsarProperties.getKeepAliveIntervalSec(), TimeUnit.SECONDS)
                .connectionTimeout(pulsarProperties.getConnectionTimeoutSec(), TimeUnit.SECONDS)
                .operationTimeout(pulsarProperties.getOperationTimeoutSec(), TimeUnit.SECONDS)
                .startingBackoffInterval(pulsarProperties.getStartingBackoffIntervalMs(), TimeUnit.MILLISECONDS)
                .maxBackoffInterval(pulsarProperties.getMaxBackoffIntervalSec(), TimeUnit.SECONDS);
        conditionBuild(clientBuilder);

        return clientBuilder.build();
    }

    private void conditionBuild(ClientBuilder clientBuilder) {
        String listenerName=pulsarProperties.getListenerName();
        if(!(listenerName == null || listenerName.length() == 0)) {
            clientBuilder.listenerName(pulsarProperties.getListenerName());//custom:+路由ID
        }
        String jwtKey=pulsarProperties.getJwtKey();
        if(!(jwtKey == null || jwtKey.length() == 0)) {
            clientBuilder.authentication(AuthenticationFactory.token(pulsarProperties.getJwtKey()));
        }

    }
}
