package io.gitee.mrxangel.enums;

import org.apache.pulsar.client.api.BatcherBuilder;
/**
 * @author 子默
 */
public enum BatcherBuilderEnum {
    BatcherBuilderDefault(0, BatcherBuilder.DEFAULT),
    BatcherBuilderDeBased(1, BatcherBuilder.KEY_BASED);


    Integer type;
    BatcherBuilder batcherBuilder;

    BatcherBuilderEnum(Integer type, BatcherBuilder batcherBuilder){
        this.type=type;
        this.batcherBuilder=batcherBuilder;
    }

    public static BatcherBuilder of(Integer type){
        BatcherBuilderEnum[] values = BatcherBuilderEnum.values();
        for (BatcherBuilderEnum e:values) {
            if(type==e.type){
                return e.batcherBuilder;
            }
        }
        return null;
    }

}
