/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.mrxangel.template;

import io.gitee.mrxangel.producer.PulsarProducerFactory;
import io.gitee.mrxangel.template.IPulsarTemplate;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.springframework.stereotype.Component;

@Component
public class PulsarTemplate
implements IPulsarTemplate {
    @Override
    public Producer producer(String topic) {
        return PulsarProducerFactory.getPulsarProducer(topic);
    }

    @Override
    public MessageId send(String topic, String msg) {
        try {
            return PulsarProducerFactory.getPulsarProducer(topic).send((Object)msg.getBytes());
        }
        catch (PulsarClientException e) {
            System.out.println("PulsarTemplate send error:" + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public MessageId send(String topic, String key, String msg) {
        try {
            return PulsarProducerFactory.getPulsarProducer(topic).newMessage().key(key).value((Object)msg.getBytes()).send();
        }
        catch (PulsarClientException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public MessageId sendDelay(String topic, String msg, long delayValue, TimeUnit unit) {
        try {
            return PulsarProducerFactory.getPulsarProducer(topic).newMessage().deliverAfter(delayValue, unit).value((Object)msg.getBytes()).send();
        }
        catch (PulsarClientException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public MessageId sendDelay(String topic, String key, String msg, long delayValue, TimeUnit unit) {
        try {
            return PulsarProducerFactory.getPulsarProducer(topic).newMessage().key(key).deliverAfter(delayValue, unit).value((Object)msg.getBytes()).send();
        }
        catch (PulsarClientException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void sendAsync(String topic, String key, String msg) {
        CompletableFuture future = PulsarProducerFactory.getPulsarProducer(topic).newMessage().key(key).value((Object)msg.getBytes()).sendAsync();
        future.handle((v, ex) -> {
            if (ex == null) {
                System.out.println("sendAsync Message : " + msg);
            } else {
                System.out.println("sendAsync Pulsar\u6d88\u606f\u5931\u8d25msg:" + msg);
            }
            return null;
        });
    }

    @Override
    public void sendAsync(String topic, String msg) {
        CompletableFuture future = PulsarProducerFactory.getPulsarProducer(topic).newMessage().value((Object)msg.getBytes()).sendAsync();
        future.handle((v, ex) -> {
            if (ex == null) {
                System.out.println("sendDelayAsync Message : " + msg);
            } else {
                System.out.println("sendAsync Pulsar\u6d88\u606f\u5931\u8d25msg:" + msg);
            }
            return null;
        });
    }

    @Override
    public void sendDelayAsync(String topic, String msg, long delayValue, TimeUnit unit) {
        CompletableFuture future = PulsarProducerFactory.getPulsarProducer(topic).newMessage().deliverAfter(delayValue, unit).value((Object)msg.getBytes()).sendAsync();
        future.handle((v, ex) -> {
            if (ex == null) {
                System.out.println("sendDelayAsync Message : " + msg);
            } else {
                System.out.println("sendDelayAsync Pulsar\u6d88\u606f\u5931\u8d25msg:" + msg);
            }
            return null;
        });
    }

    @Override
    public void sendDelayAsync(String topic, String key, String msg, long delayValue, TimeUnit unit) {
        CompletableFuture future = PulsarProducerFactory.getPulsarProducer(topic).newMessage().key(key).deliverAfter(delayValue, unit).value((Object)msg.getBytes()).sendAsync();
        future.handle((v, ex) -> {
            if (ex == null) {
                System.out.println("sendDelayAsync Message : " + msg);
            } else {
                System.out.println("sendDelayAsync Pulsar\u6d88\u606f\u5931\u8d25msg:" + msg);
            }
            return null;
        });
    }
}

