package io.gitee.mrxangel.template;

import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;

import java.util.concurrent.TimeUnit;

public interface IPulsarTemplate {
    public Producer producer(String topic);

    public MessageId send(String topic, String msg);

    public MessageId send(String topic,String key, String msg);

    public MessageId sendDelay(String topic, String msg, long delayValue, TimeUnit unit);

    public MessageId sendDelay(String topic,String key, String msg, long delayValue, TimeUnit unit);

    public void sendAsync(String topic, String msg);

    public void sendAsync(String topic,String key, String msg);

    public void sendDelayAsync(String topic, String msg, long delayValue, TimeUnit unit);

    public void sendDelayAsync(String topic,String key, String msg, long delayValue, TimeUnit unit);

}
