package io.gitee.mrxangel.enums;

import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.MessageRoutingMode;

public enum MessageRoutingModeEnum {
    SinglePartition(0,MessageRoutingMode.SinglePartition),
    RobinPartition(1,MessageRoutingMode.RoundRobinPartition),
    Partition(2,MessageRoutingMode.CustomPartition);


    Integer type;
    MessageRoutingMode messageRoutingMode;

    MessageRoutingModeEnum(Integer type, MessageRoutingMode messageRoutingMode){
        this.type=type;
        this.messageRoutingMode=messageRoutingMode;
    }

    public static MessageRoutingMode of(Integer type){
        MessageRoutingModeEnum[] values = MessageRoutingModeEnum.values();
        for (MessageRoutingModeEnum e:values) {
            if(type==e.type){
                return e.messageRoutingMode;
            }
        }
        return null;
    }

}
