package io.gitee.mrxangel.template;

import io.gitee.mrxangel.producer.PulsarProducerFactory;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.springframework.stereotype.Component;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

@Component
public class PulsarTemplate implements IPulsarTemplate {

    @Override
    public Producer producer(String topic) {
        return PulsarProducerFactory.getPulsarProducer(topic);
    }

    @Override
    public MessageId send(String topic, String msg){
        //noinspection unchecked
        try {
            return PulsarProducerFactory.getPulsarProducer(topic).send(msg.getBytes());
        } catch (PulsarClientException e) {
            System.out.println("PulsarTemplate send error:"+e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public MessageId send(String topic,String key, String msg) {
        try {
            return PulsarProducerFactory.getPulsarProducer(topic).newMessage()
                    .key(key)
                    .value(msg.getBytes()).send();
        } catch (PulsarClientException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public MessageId sendDelay(String topic, String msg, long delayValue, TimeUnit unit){
        try {
            return PulsarProducerFactory.getPulsarProducer(topic).newMessage()
                    .deliverAfter(delayValue, unit)
                    .value(msg.getBytes()).send();//异步发送
        } catch (PulsarClientException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public MessageId sendDelay(String topic,String key, String msg, long delayValue, TimeUnit unit){
        try {
            return PulsarProducerFactory.getPulsarProducer(topic).newMessage()
                    .key(key)
                    .deliverAfter(delayValue, unit)
                    .value(msg.getBytes()).send();//异步发送
        } catch (PulsarClientException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 异步发送
     * @param topic 主题
     * @param key key
     * @param msg 内容
     */
    @Override
    public void sendAsync(String topic,String key, String msg){
        CompletableFuture<MessageId> future = PulsarProducerFactory.getPulsarProducer(topic).newMessage()
                .key(key)
                .value(msg.getBytes()).sendAsync();//异步发送
        future.handle((v, ex) -> {
            if (ex == null) {
                System.out.println("sendAsync Message : "+ msg);
            } else {
                System.out.println("sendAsync Pulsar消息失败msg:"+msg);
            }
            return null;
        });
    }
    /**
     * 异步发送
     * @param topic 主题
     * @param msg 内容
     */
    @Override
    public void sendAsync(String topic, String msg){
        CompletableFuture<MessageId> future = PulsarProducerFactory.getPulsarProducer(topic).newMessage()
                .value(msg.getBytes()).sendAsync();//异步发送
        future.handle((v, ex) -> {
            if (ex == null) {
                System.out.println("sendDelayAsync Message : "+ msg);
            } else {
                System.out.println("sendAsync Pulsar消息失败msg:"+msg);
            }
            return null;
        });
    }

    @Override
    public void sendDelayAsync(String topic, String msg, long delayValue, TimeUnit unit){
        CompletableFuture<MessageId> future = PulsarProducerFactory.getPulsarProducer(topic).newMessage()
                .deliverAfter(delayValue, unit)
                .value(msg.getBytes()).sendAsync();//异步发送
        future.handle((v, ex) -> {
            if (ex == null) {
                System.out.println("sendDelayAsync Message : "+ msg);
            } else {
                System.out.println("sendDelayAsync Pulsar消息失败msg:"+msg);
            }
            return null;
        });
    }

    @Override
    public void sendDelayAsync(String topic,String key, String msg, long delayValue, TimeUnit unit){
        CompletableFuture<MessageId> future = PulsarProducerFactory.getPulsarProducer(topic).newMessage()
                .key(key)
                .deliverAfter(delayValue, unit)
                .value(msg.getBytes()).sendAsync();//异步发送
        future.handle((v, ex) -> {
            if (ex == null) {
                System.out.println("sendDelayAsync Message : "+ msg);
            } else {
                System.out.println("sendDelayAsync Pulsar消息失败msg:"+msg);
            }
            return null;
        });
    }
}
