/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.mrxangel.producer;

import io.gitee.mrxangel.PulsarProperties;
import io.gitee.mrxangel.enums.BatcherBuilderEnum;
import io.gitee.mrxangel.enums.CompressionTypeEnum;
import io.gitee.mrxangel.producer.PulsarProducer;
import io.gitee.mrxangel.producer.PulsarProducerFactory;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
public class PulsarProducerHandler
implements BeanPostProcessor {
    @Resource
    private PulsarClient pulsarClient;
    @Resource
    private PulsarProperties pulsarProperties;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Arrays.stream(bean.getClass().getFields()).filter(v -> v.isAnnotationPresent(PulsarProducer.class)).forEach(method -> {
            PulsarProducer annotation = method.getAnnotation(PulsarProducer.class);
            this.initProducer(annotation.topic());
        });
        return bean;
    }

    public void initProducer(String topic) {
        try {
            Producer producer = this.pulsarClient.newProducer().topic(topic).enableBatching(this.pulsarProperties.getEnableBatching().booleanValue()).compressionType(CompressionTypeEnum.of(this.pulsarProperties.getCompressionType())).batchingMaxPublishDelay((long)this.pulsarProperties.getBatchingMaxPublishDelay().intValue(), TimeUnit.MILLISECONDS).sendTimeout(this.pulsarProperties.getSendTimeout().intValue(), TimeUnit.SECONDS).batchingMaxMessages(this.pulsarProperties.getBatchingMaxMessages().intValue()).maxPendingMessages(this.pulsarProperties.getMaxPendingMessages().intValue()).blockIfQueueFull(this.pulsarProperties.getBlockIfQueueFull().booleanValue()).roundRobinRouterBatchingPartitionSwitchFrequency(this.pulsarProperties.getRoundRobinRouterBatchingPartitionSwitchFrequency().intValue()).batcherBuilder(BatcherBuilderEnum.of(this.pulsarProperties.getBatcherBuilder())).create();
            PulsarProducerFactory.addPulsarProducerFactory(topic, producer);
        }
        catch (PulsarClientException e) {
            e.printStackTrace();
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }
}

