package io.gitee.mrxangel;


import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix = "pulsar")
public class PulsarProperties {
    private String serviceUrl = "pulsar://localhost:6650";
    //client相关参数
    private String listenerName = "";
    private String jwtKey = "";
    private Integer ioThreads = 10;
    private Integer listenerThreads = 10;
    private boolean enableTcpNoDelay = false;
    private Integer keepAliveIntervalSec = 20;
    private Integer connectionTimeoutSec = 10;
    private Integer operationTimeoutSec = 15;
    private Integer startingBackoffIntervalMs = 100;
    private Integer maxBackoffIntervalSec = 10;

    //生产者端相关参数
    private Boolean enableBatching=true; //是否开启批量处理消息，默认true,需要注意的是enableBatching只在异步发送sendAsync生效，同步发送send失效。因此建议生产环境若想使用批处理，则需使用异步发送，或者多线程同步发送
    private Integer compressionType=1; //消息压缩（四种压缩方式：1：LZ4:2：ZLIB:3：ZSTD:4：SNAPPY），consumer端不用做改动就能消费，开启后大约可以降低3/4带宽消耗和存储（官方测试）
    private Integer batchingMaxPublishDelay=10; //TimeUnit.MILLISECONDS 设置将对发送的消息进行批处理的时间段,10ms；可以理解为若该时间段内批处理成功，则一个batch中的消息数量不会被该参数所影响。
    private Integer sendTimeout=0 ;  //TimeUnit.SECONDS 设置发送超时0s；如果在sendTimeout过期之前服务器没有确认消息，则会发生错误。默认30s，设置为0代表无限制，建议配置为0
    private Integer batchingMaxMessages=1000;  //批处理中允许的最大消息数。默认1000
    private Integer maxPendingMessages=1000 ; //设置等待接受来自broker确认消息的队列的最大大小，默认1000
    private Boolean blockIfQueueFull=true;  //设置当消息队列中等待的消息已满时，Producer.send 和 Producer.sendAsync 是否应该block阻塞。默认为false，达到maxPendingMessages后send操作会报错，设置为true后，send操作阻塞但是不报错。建议设置为true
    private Integer roundRobinRouterBatchingPartitionSwitchFrequency=10; //向不同partition分发消息的切换频率，默认10ms，可根据batch情况灵活调整
    private Integer batcherBuilder=1; //1：BatcherBuilder.DEFAULT  2：BatcherBuilder.KEY_BASED

    //消费者
    private String   subscription="subscription_default";
    private Integer  subscriptionType= 1;//Shared 指定消费模式，包含：Exclusive，Failover，Shared，Key_Shared。默认Exclusive模式
    private Integer  subscriptionInitialPosition=1;//SubscriptionInitialPosition.Earliest 指定从哪里开始消费还有Latest，valueof可选，默认Latest
    private Integer  negativeAckRedeliveryDelay=60;//指定消费失败后延迟多久broker重新发送消息给consumer，默认60s TimeUnit.SECONDS

    public String getServiceUrl() {
        return serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getListenerName() {
        return listenerName;
    }

    public void setListenerName(String listenerName) {
        this.listenerName = listenerName;
    }

    public String getJwtKey() {
        return jwtKey;
    }

    public void setJwtKey(String jwtKey) {
        this.jwtKey = jwtKey;
    }

    public Integer getIoThreads() {
        return ioThreads;
    }

    public void setIoThreads(Integer ioThreads) {
        this.ioThreads = ioThreads;
    }

    public Integer getListenerThreads() {
        return listenerThreads;
    }

    public void setListenerThreads(Integer listenerThreads) {
        this.listenerThreads = listenerThreads;
    }

    public boolean isEnableTcpNoDelay() {
        return enableTcpNoDelay;
    }

    public void setEnableTcpNoDelay(boolean enableTcpNoDelay) {
        this.enableTcpNoDelay = enableTcpNoDelay;
    }

    public Integer getKeepAliveIntervalSec() {
        return keepAliveIntervalSec;
    }

    public void setKeepAliveIntervalSec(Integer keepAliveIntervalSec) {
        this.keepAliveIntervalSec = keepAliveIntervalSec;
    }

    public Integer getConnectionTimeoutSec() {
        return connectionTimeoutSec;
    }

    public void setConnectionTimeoutSec(Integer connectionTimeoutSec) {
        this.connectionTimeoutSec = connectionTimeoutSec;
    }

    public Integer getOperationTimeoutSec() {
        return operationTimeoutSec;
    }

    public void setOperationTimeoutSec(Integer operationTimeoutSec) {
        this.operationTimeoutSec = operationTimeoutSec;
    }

    public Integer getStartingBackoffIntervalMs() {
        return startingBackoffIntervalMs;
    }

    public void setStartingBackoffIntervalMs(Integer startingBackoffIntervalMs) {
        this.startingBackoffIntervalMs = startingBackoffIntervalMs;
    }

    public Integer getMaxBackoffIntervalSec() {
        return maxBackoffIntervalSec;
    }

    public void setMaxBackoffIntervalSec(Integer maxBackoffIntervalSec) {
        this.maxBackoffIntervalSec = maxBackoffIntervalSec;
    }

    public Boolean getEnableBatching() {
        return enableBatching;
    }

    public void setEnableBatching(Boolean enableBatching) {
        this.enableBatching = enableBatching;
    }

    public Integer getCompressionType() {
        return compressionType;
    }

    public void setCompressionType(Integer compressionType) {
        this.compressionType = compressionType;
    }

    public Integer getBatchingMaxPublishDelay() {
        return batchingMaxPublishDelay;
    }

    public void setBatchingMaxPublishDelay(Integer batchingMaxPublishDelay) {
        this.batchingMaxPublishDelay = batchingMaxPublishDelay;
    }

    public Integer getSendTimeout() {
        return sendTimeout;
    }

    public void setSendTimeout(Integer sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public Integer getBatchingMaxMessages() {
        return batchingMaxMessages;
    }

    public void setBatchingMaxMessages(Integer batchingMaxMessages) {
        this.batchingMaxMessages = batchingMaxMessages;
    }

    public Integer getMaxPendingMessages() {
        return maxPendingMessages;
    }

    public void setMaxPendingMessages(Integer maxPendingMessages) {
        this.maxPendingMessages = maxPendingMessages;
    }

    public Boolean getBlockIfQueueFull() {
        return blockIfQueueFull;
    }

    public void setBlockIfQueueFull(Boolean blockIfQueueFull) {
        this.blockIfQueueFull = blockIfQueueFull;
    }

    public Integer getRoundRobinRouterBatchingPartitionSwitchFrequency() {
        return roundRobinRouterBatchingPartitionSwitchFrequency;
    }

    public void setRoundRobinRouterBatchingPartitionSwitchFrequency(Integer roundRobinRouterBatchingPartitionSwitchFrequency) {
        this.roundRobinRouterBatchingPartitionSwitchFrequency = roundRobinRouterBatchingPartitionSwitchFrequency;
    }

    public Integer getBatcherBuilder() {
        return batcherBuilder;
    }

    public void setBatcherBuilder(Integer batcherBuilder) {
        this.batcherBuilder = batcherBuilder;
    }

    public String getSubscription() {
        return subscription;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public Integer getSubscriptionType() {
        return subscriptionType;
    }

    public void setSubscriptionType(Integer subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public Integer getSubscriptionInitialPosition() {
        return subscriptionInitialPosition;
    }

    public void setSubscriptionInitialPosition(Integer subscriptionInitialPosition) {
        this.subscriptionInitialPosition = subscriptionInitialPosition;
    }

    public Integer getNegativeAckRedeliveryDelay() {
        return negativeAckRedeliveryDelay;
    }

    public void setNegativeAckRedeliveryDelay(Integer negativeAckRedeliveryDelay) {
        this.negativeAckRedeliveryDelay = negativeAckRedeliveryDelay;
    }
}
