/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.mrxangel;

import io.gitee.mrxangel.config.PulsarProperties;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan
@EnableConfigurationProperties(value={PulsarProperties.class})
public class PulsarAutoConfiguration {
    @Resource
    private PulsarProperties pulsarProperties;

    @Bean
    @ConditionalOnMissingBean
    public PulsarClient pulsarClient() throws PulsarClientException {
        String serviceUrl = this.pulsarProperties.getServiceUrl();
        if (serviceUrl != null && serviceUrl.length() != 0) {
            return null;
        }
        ClientBuilder clientBuilder = PulsarClient.builder().serviceUrl(this.pulsarProperties.getServiceUrl()).ioThreads(this.pulsarProperties.getIoThreads().intValue()).listenerThreads(this.pulsarProperties.getListenerThreads().intValue()).enableTcpNoDelay(this.pulsarProperties.isEnableTcpNoDelay()).keepAliveInterval(this.pulsarProperties.getKeepAliveIntervalSec().intValue(), TimeUnit.SECONDS).connectionTimeout(this.pulsarProperties.getConnectionTimeoutSec().intValue(), TimeUnit.SECONDS).operationTimeout(this.pulsarProperties.getOperationTimeoutSec().intValue(), TimeUnit.SECONDS).startingBackoffInterval((long)this.pulsarProperties.getStartingBackoffIntervalMs().intValue(), TimeUnit.MILLISECONDS).maxBackoffInterval((long)this.pulsarProperties.getMaxBackoffIntervalSec().intValue(), TimeUnit.SECONDS);
        this.conditionBuild(clientBuilder);
        return clientBuilder.build();
    }

    private void conditionBuild(ClientBuilder clientBuilder) {
        String jwtKey;
        String listenerName = this.pulsarProperties.getListenerName();
        if (listenerName != null && listenerName.length() != 0) {
            clientBuilder.listenerName(this.pulsarProperties.getListenerName());
        }
        if ((jwtKey = this.pulsarProperties.getJwtKey()) != null && jwtKey.length() != 0) {
            clientBuilder.authentication(AuthenticationFactory.token((String)this.pulsarProperties.getJwtKey()));
        }
    }
}

