package io.gitee.mrxangel.consumer;

import io.gitee.mrxangel.config.PulsarProperties;
import io.gitee.mrxangel.enums.SubscriptionInitialPositionEnum;
import io.gitee.mrxangel.enums.SubscriptionTypeEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

@Component
@Configuration
public class PulsarConsumerHandler implements BeanPostProcessor {
   /* @Resource*/
    private  PulsarClient pulsarClient;
    public PulsarConsumerHandler(PulsarClient pulsarClient) {
        this.pulsarClient = pulsarClient;
    }
    @Resource
    private PulsarProperties pulsarProperties;

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Arrays.stream(bean.getClass().getDeclaredMethods()).filter(v -> v.isAnnotationPresent(PulsarConsumerListener.class)).forEach(method->{
            PulsarConsumerListener annotation = method.getAnnotation(PulsarConsumerListener.class);
            initConsumer( bean,method,annotation);
        });

        return bean;
    }

    /**
     * 初始化消费者
     * @param bean 对象
     * @param method 方法
     * @param annotation 注解
     */
    public void initConsumer(Object bean, Method method, PulsarConsumerListener annotation){
        try {
            pulsarClient.newConsumer()
                    //.consumerName("com-renx")
                    .topic(annotation.destination())
                    .subscriptionName(StringUtils.isAllEmpty(annotation.subscriptionName())?pulsarProperties.getSubscription():annotation.subscriptionName())
                    .subscriptionType(SubscriptionTypeEnum.of(pulsarProperties.getSubscriptionType()))//指定消费模式，包含：Exclusive，Failover，Shared，Key_Shared。默认Exclusive模式
                    .subscriptionInitialPosition(SubscriptionInitialPositionEnum.of(pulsarProperties.getSubscriptionInitialPosition()))//指定从哪里开始消费还有Latest，valueof可选，默认Latest
                    .negativeAckRedeliveryDelay(pulsarProperties.getNegativeAckRedeliveryDelay(), TimeUnit.SECONDS)//指定消费失败后延迟多久broker重新发送消息给consumer，默认60s
                    .messageListener((consumer, msg) -> {
                        try {
                            method.setAccessible(true);
                            method.invoke(bean,msg);

                            consumer.acknowledge(msg);
                        } catch (Exception e) {
                            consumer.negativeAcknowledge(msg);
                            throw new RuntimeException("TODO Custom Exception!", e);
                        }
                    })
                    .subscribe();
        } catch (PulsarClientException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }
}
