/*
 * Decompiled with CFR 0.152.
 */
package com.lk.http.handler.impl;

import com.lk.http.RPCEntranceDispatcher;
import com.lk.http.handler.UrlProcessor;
import com.lk.response.ResponseUtils;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUrlProcessor
implements UrlProcessor {
    public static Logger LOG = LoggerFactory.getLogger(DefaultUrlProcessor.class);
    static Pattern pattern = Pattern.compile("/web/j/(.*?)\\.(.*?)\\.rpc");
    static RPCEntranceDispatcher rpcEntranceDispatcher = new RPCEntranceDispatcher();

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            Matcher matcher = pattern.matcher(request.getRequestURI());
            if (matcher.find()) {
                String beanName = matcher.group(1);
                String methodName = matcher.group(2);
                rpcEntranceDispatcher.call(response, request, beanName, methodName);
                return;
            }
            ResponseUtils.outputError(response, "URL \u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        catch (Throwable throwable) {
            LOG.error(throwable.getMessage(), throwable);
            ResponseUtils.outputError(response, throwable.getMessage());
        }
    }
}

