/*
 * Decompiled with CFR 0.152.
 */
package com.lk.http.argument;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.lk.exceptions.NotSupportRequestContentTypeException;
import com.lk.exceptions.ParameterNotMatcherException;
import com.lk.http.argument.ArgumentNameDiscovererUtils;
import com.lk.http.method.MethodValueInfo;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class ParseParametersUtils {
    public static List<Object> parseParametersForURLEncode(Method method, HttpServletRequest request) {
        if (method.getParameterTypes().length == 0) {
            return new ArrayList<Object>();
        }
        List<MethodValueInfo> parameterNameValues = ArgumentNameDiscovererUtils.getCachedArgumentNames(method);
        ArrayList<Object> requestParameterValues = new ArrayList<Object>();
        for (MethodValueInfo parameterNameValue : parameterNameValues) {
            String parameterValue = ParseParametersUtils.getRequestParameter(request, parameterNameValue);
            Object o = ParseParametersUtils.deserializationObject(parameterNameValue, parameterValue);
            if (parameterNameValue.isRequired() && o == null) {
                throw new ParameterNotMatcherException("parameterName \u8981\u6c42\u5fc5\u987b:" + parameterNameValue.isRequired() + ", but " + parameterNameValue.getName() + " \u8bf7\u6c42\u503c\u7f3a\u5931!");
            }
            if (o == null && StringUtils.isNotEmpty((String)parameterNameValue.getDefaultValue())) {
                o = ParseParametersUtils.deserializationObject(parameterNameValue, parameterNameValue.getDefaultValue());
            }
            requestParameterValues.add(o);
        }
        return requestParameterValues;
    }

    public static String getRequestParameter(HttpServletRequest request, MethodValueInfo methodValueInfo) {
        if (StringUtils.contains((String)request.getContentType(), (String)"application/x-www-form-urlencoded")) {
            String value = request.getParameter(methodValueInfo.getName());
            return value;
        }
        throw new NotSupportRequestContentTypeException("\u4e0d\u652f\u6301\u7c7b\u578b:" + request.getContentType());
    }

    public static Object deserializationObject(MethodValueInfo parameter, String stringValue) {
        if (parameter.getType() instanceof Class && ParseParametersUtils.isPrimitive(parameter.getClazz())) {
            return ParseParametersUtils.convert2Primitive(parameter.getClazz(), stringValue);
        }
        return JSONObject.parseObject((String)stringValue, (Type)parameter.getType(), (Feature[])new Feature[0]);
    }

    public static boolean isPrimitive(Class<?> parameterType) {
        if (ParseParametersUtils.isLong(parameterType)) {
            return true;
        }
        if (ParseParametersUtils.isBoolean(parameterType)) {
            return true;
        }
        if (ParseParametersUtils.isFloat(parameterType)) {
            return true;
        }
        if (ParseParametersUtils.isDouble(parameterType)) {
            return true;
        }
        if (ParseParametersUtils.isInt(parameterType)) {
            return true;
        }
        return ParseParametersUtils.isString(parameterType);
    }

    public static Object convert2Primitive(Class<?> parameterType, String parameterValue) {
        try {
            if (parameterValue == null) {
                return null;
            }
            if (ParseParametersUtils.isLong(parameterType)) {
                return Long.valueOf(parameterValue);
            }
            if (ParseParametersUtils.isBoolean(parameterType)) {
                return Boolean.valueOf(parameterValue);
            }
            if (ParseParametersUtils.isFloat(parameterType)) {
                return Float.valueOf(parameterValue);
            }
            if (ParseParametersUtils.isDouble(parameterType)) {
                return Double.valueOf(parameterValue);
            }
            if (ParseParametersUtils.isInt(parameterType)) {
                return Integer.valueOf(parameterValue);
            }
            return parameterValue;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isLong(Class<?> clazz) {
        return clazz.getName().equalsIgnoreCase("long") || clazz.getName().equalsIgnoreCase("java.lang.long");
    }

    public static boolean isDouble(Class<?> clazz) {
        return clazz.getName().equalsIgnoreCase("double") || clazz.getName().equalsIgnoreCase("java.lang.double");
    }

    public static boolean isFloat(Class<?> clazz) {
        return clazz.getName().equalsIgnoreCase("float") || clazz.getName().equalsIgnoreCase("java.lang.float");
    }

    public static boolean isBoolean(Class<?> clazz) {
        return clazz.getName().equalsIgnoreCase("boolean") || clazz.getName().equalsIgnoreCase("java.lang.boolean");
    }

    public static boolean isInt(Class<?> clazz) {
        return clazz.getName().equalsIgnoreCase("int") || clazz.getName().equalsIgnoreCase("java.lang.integer");
    }

    public static boolean isString(Class<?> clazz) {
        return clazz.getName().equalsIgnoreCase("java.lang.string");
    }
}

