/*
 * Decompiled with CFR 0.152.
 */
package com.lk.http.argument;

import com.lk.annotation.RpcParamRequired;
import com.lk.http.method.MethodValueInfo;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;

public class ArgumentNameDiscovererUtils {
    static Paranamer paranamer = new BytecodeReadingParanamer();
    static Map<Method, List<MethodValueInfo>> argumentNamesResolverCacheMap = new ConcurrentHashMap<Method, List<MethodValueInfo>>();

    public static List<MethodValueInfo> getCachedArgumentNames(Method method) {
        List<MethodValueInfo> methodValueInfoList = argumentNamesResolverCacheMap.get(method);
        if (CollectionUtils.isEmpty(methodValueInfoList)) {
            String[] results = paranamer.lookupParameterNames((AccessibleObject)method);
            methodValueInfoList = new ArrayList<MethodValueInfo>();
            for (String result : results) {
                methodValueInfoList.add(new MethodValueInfo(result, false, null));
            }
            ArgumentNameDiscovererUtils.updateNameValues(method, methodValueInfoList);
            argumentNamesResolverCacheMap.put(method, methodValueInfoList);
            return methodValueInfoList;
        }
        return methodValueInfoList;
    }

    private static void updateNameValues(Method method, List<MethodValueInfo> methodValueInfoList) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        if (methodValueInfoList.size() != parameterTypes.length) {
            throw new IllegalArgumentException("\u6ce8\u89e3\u5217\u8868\u4e2a\u6570\u4e0e\u65b9\u6cd5\u6570\u4e0d\u5339\u914d");
        }
        int idx = 0;
        for (Class<?> parameterType : parameterTypes) {
            methodValueInfoList.get(idx).setClazz(parameterType);
            methodValueInfoList.get(idx).setType(genericParameterTypes[idx]);
            ++idx;
        }
        int index = 0;
        for (Annotation[] parameterAnnotation : parameterAnnotations) {
            if (parameterAnnotation.length == 0) {
                ++index;
                continue;
            }
            MethodValueInfo methodValueInfo = methodValueInfoList.get(index);
            for (Annotation annotation : parameterAnnotation) {
                if (!(annotation instanceof RpcParamRequired)) continue;
                RpcParamRequired rpcParamRequired = (RpcParamRequired)annotation;
                methodValueInfo.setRequired(rpcParamRequired.required());
                methodValueInfo.setDefaultValue(rpcParamRequired.defaultValue());
            }
            ++index;
        }
    }
}

