/*
 * Decompiled with CFR 0.152.
 */
package com.lk.http;

import com.lk.annotation.RpcMethod;
import com.lk.exceptions.MethodNotFindException;
import com.lk.exceptions.MoreThanOneMethodException;
import com.lk.http.argument.ParseParametersUtils;
import com.lk.http.context.SpringContextUtil;
import com.lk.response.JsonResponseCode;
import com.lk.response.ResponseUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class RPCEntranceDispatcher {
    public void call(HttpServletResponse response, HttpServletRequest request, String beanName, String methodName) throws Throwable {
        Object bean;
        try {
            bean = SpringContextUtil.getBean(beanName);
        }
        catch (Throwable throwable) {
            throw new Throwable("\u672a\u627e\u5230\u5bf9\u5e94\u7684bean");
        }
        if (StringUtils.isBlank((String)beanName) || StringUtils.isBlank((String)methodName)) {
            ResponseUtils.outputError(response, "\u8bf7\u6c42\u53c2\u6570\u7f3a\u5931\uff0c\u7c7b\u540d\u6216\u8005\u65b9\u6cd5\u540d\u627e\u4e0d\u5230");
            return;
        }
        Method method = null;
        method = this.findMethodOnlyByName(bean, methodName);
        if (method == null) {
            ResponseUtils.outputError(response, "can't find method:" + methodName);
            return;
        }
        if (StringUtils.contains((String)request.getContentType(), (String)"application/x-www-form-urlencoded")) {
            this.proceedByParamInput(request, response, bean, method);
        } else {
            ResponseUtils.outputError(response, "can't recognize contentType:" + request.getContentType() + ", only support:" + Collections.singletonList("application/x-www-form-urlencoded"));
        }
    }

    private Method findMethodOnlyByName(Object bean, String methodName) {
        Method[] methods = bean.getClass().getMethods();
        Method matchedMethod = null;
        int matched = 0;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName) || methods[i].getAnnotation(RpcMethod.class) == null) continue;
            ++matched;
            matchedMethod = methods[i];
        }
        if (matched > 1) {
            throw new MoreThanOneMethodException((int)JsonResponseCode.ERROR_METHOD_CANT_FIND, " find more than one!" + methodName);
        }
        if (matched < 1) {
            throw new MethodNotFindException((int)JsonResponseCode.ERROR_METHOD_CANT_FIND, " find no such method:" + methodName);
        }
        return matchedMethod;
    }

    private void proceedByParamInput(HttpServletRequest request, HttpServletResponse response, Object bean, Method method) throws IOException {
        Object[] paramArray = null;
        try {
            List<Object> parametersForInput = ParseParametersUtils.parseParametersForURLEncode(method, request);
            paramArray = parametersForInput.toArray(new Object[parametersForInput.size()]);
            Object result = method.invoke(bean, paramArray);
            ResponseUtils.output(response, result);
        }
        catch (Exception e) {
            ResponseUtils.outputError(response, "\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
    }
}

