package com.lk.servlet;

import com.lk.http.handler.UrlProcessor;
import com.lk.http.handler.impl.DefaultUrlProcessor;
import com.lk.response.ResponseUtils;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;


/**
 * @author lk
 */
public class RpcServlet extends HttpServlet {

    private UrlProcessor urlProcessor;
    private static final long serialVersionUID = -4619665430596950563L;


    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        urlProcessor = new DefaultUrlProcessor();
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ResponseUtils.outputError(resp, "Get request method is not allowed");
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        urlProcessor.handle(req, resp);
    }

}