package com.lk.response;


/**
 * @author lk
 */
public class CommonResult {
    /**
     * 状态码
     */
    private int code = 0;

    /**
     * 状态描述
     */
    private String message = "";

    /**
     * 返回数据
     */
    private Object data;


    /**
     * 成功返回结果
     *
     * @param data 获取的数据
     */
    public static CommonResult success(Object data) {
        return new CommonResult(data);
    }

    /**
     * 失败返回结果
     *
     * @param errorCode 错误码
     * @param message   错误信息
     */
    public static CommonResult failed(int errorCode, String message) {
        return new CommonResult(errorCode, message, null);
    }


    public CommonResult() {
    }

    public CommonResult(Object data) {
        this.data = data;
    }

    public CommonResult(int code, String message, Object data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

}
