package com.lk.http.argument;


import com.alibaba.fastjson.JSONObject;
import com.lk.exceptions.NotSupportRequestContentTypeException;
import com.lk.exceptions.ParameterNotMatcherException;
import com.lk.http.entity.ContentType;
import com.lk.http.method.MethodValueInfo;
import org.apache.commons.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/**
 * @author lk
 */
public class ParseParametersUtils {

    public static List<Object> parseParametersForURLEncode(Method method, HttpServletRequest request) {
        if (method.getParameterTypes().length == 0) {
            return new ArrayList<Object>();
        }
        List<MethodValueInfo> parameterNameValues = ArgumentNameDiscovererUtils.getCachedArgumentNames(method);
        List<Object> requestParameterValues = new ArrayList<Object>();
        for (MethodValueInfo parameterNameValue : parameterNameValues) {
            String parameterValue = getRequestParameter(request, parameterNameValue);
            Object o = deserializationObject(parameterNameValue, parameterValue);
            if (parameterNameValue.isRequired() && o == null) {
                throw new ParameterNotMatcherException("parameterName 要求必须:" + parameterNameValue.isRequired() + ", but " + parameterNameValue.getName() + " 请求值缺失!");
            }
            if (o == null && StringUtils.isNotEmpty(parameterNameValue.getDefaultValue())) {
                o = ParseParametersUtils.deserializationObject(parameterNameValue, parameterNameValue.getDefaultValue());
            }
            requestParameterValues.add(o);
        }
        return requestParameterValues;
    }

    public static String getRequestParameter(HttpServletRequest request, MethodValueInfo methodValueInfo) {
        if (StringUtils.contains(request.getContentType(), ContentType.APPLICATION_FORM_URLENCODED)) {
            String value = request.getParameter(methodValueInfo.getName());
            return value;
        } else {
            throw new NotSupportRequestContentTypeException("不支持类型:" + request.getContentType());
        }
    }

    public static Object deserializationObject(final MethodValueInfo parameter, String stringValue) {
        if (parameter.getType() instanceof Class && isPrimitive(parameter.getClazz())) {
            return convert2Primitive(parameter.getClazz(), stringValue);
        } else {
            return JSONObject.parseObject(stringValue, parameter.getType());
        }
    }

    public static boolean isPrimitive(Class<?> parameterType) {

        if (isLong(parameterType)) {
            return true;
        } else if (isBoolean(parameterType)) {
            return true;
        } else if (isFloat(parameterType)) {
            return true;
        } else if (isDouble(parameterType)) {
            return true;
        } else if (isInt(parameterType)) {
            return true;
        } else if (isString(parameterType)) {
            return true;
        }
        return false;

    }

    public static Object convert2Primitive(Class<?> parameterType, String parameterValue) {
        try {
            if (parameterValue == null) {
                return null;
            }
            if (isLong(parameterType)) {
                return Long.valueOf(parameterValue);
            } else if (isBoolean(parameterType)) {
                return Boolean.valueOf(parameterValue);
            } else if (isFloat(parameterType)) {
                return Float.valueOf(parameterValue);
            } else if (isDouble(parameterType)) {
                return Double.valueOf(parameterValue);
            } else if (isInt(parameterType)) {
                return Integer.valueOf(parameterValue);
            } else {
                return parameterValue;
            }
        } catch (Exception e) {
            return null;
        }
    }

    public static boolean isLong(Class<?> clazz) {
        return clazz.getName().equalsIgnoreCase("long") || clazz.getName().equalsIgnoreCase("java.lang.long");
    }

    public static boolean isDouble(Class<?> clazz) {
        return clazz.getName().equalsIgnoreCase("double") || clazz.getName().equalsIgnoreCase("java.lang.double");
    }

    public static boolean isFloat(Class<?> clazz) {
        return clazz.getName().equalsIgnoreCase("float") || clazz.getName().equalsIgnoreCase("java.lang.float");
    }

    public static boolean isBoolean(Class<?> clazz) {
        return clazz.getName().equalsIgnoreCase("boolean") || clazz.getName().equalsIgnoreCase("java.lang.boolean");
    }

    public static boolean isInt(Class<?> clazz) {
        return clazz.getName().equalsIgnoreCase("int") || clazz.getName().equalsIgnoreCase("java.lang.integer");
    }

    public static boolean isString(Class<?> clazz) {
        return clazz.getName().equalsIgnoreCase("java.lang.string");
    }


}
