/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.jaemon.sqldata.mock.utils;

import io.gitee.jaemon.sqldata.mock.utils.CityCode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Random;

public class MockRandomUtils {
    private static final char[] UPPER_CASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] LOWER_CASE = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] UPPER_LOWER_CASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] NUM_CASE = "0123456789".toCharArray();
    private static final char[] ID_LAST_THREE_CASE = "0123456789x".toCharArray();
    private static final char[] CHAR_NUM_CASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    private static final String CONNECTOR = "-";
    public static final Random random = new Random();
    public static final DateTimeFormatter DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static String generateChars(int length) {
        return MockRandomUtils.generate(UPPER_LOWER_CASE, length);
    }

    public static String generateNums(int length) {
        return MockRandomUtils.generate(NUM_CASE, length);
    }

    public static String generateCharNums(int length) {
        return MockRandomUtils.generate(CHAR_NUM_CASE, length);
    }

    public static String date(boolean connector) {
        String dayVal;
        String monthVal;
        int yearBound = LocalDate.now().getYear() - 1700;
        int year = random.nextInt(yearBound) + 1700;
        int month = random.nextInt(12) + 1;
        String string = monthVal = month < 10 ? "0" + month : String.valueOf(month);
        int dayBound = month == 2 ? (year % 4 == 0 ? 28 : 29) : 30;
        int day = random.nextInt(dayBound) + 1;
        String string2 = dayVal = day < 10 ? "0" + day : String.valueOf(day);
        if (connector) {
            return year + CONNECTOR + monthVal + CONNECTOR + dayVal;
        }
        return year + monthVal + dayVal;
    }

    public static String idNo() {
        StringBuilder result = new StringBuilder(18);
        result.append(MockRandomUtils.intRandom(CityCode.cities));
        result.append(MockRandomUtils.date(false));
        result.append(MockRandomUtils.generateNums(3));
        result.append(MockRandomUtils.generate(ID_LAST_THREE_CASE, 1));
        return result.toString();
    }

    public static int intRandom(int[] ints) {
        return ints[random.nextInt(ints.length)];
    }

    public static String stringRandom(String[] stirngs) {
        return stirngs[random.nextInt(stirngs.length)];
    }

    private static String generate(char[] source, int length) {
        StringBuilder result = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(source.length);
            result.append(source[index]);
        }
        return result.toString();
    }

    public static void main(String[] args) {
        for (int i = 0; i < 10; ++i) {
            System.out.println(MockRandomUtils.idNo());
        }
    }
}

