/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.jaemon.sqldata.mock.core;

import io.gitee.jaemon.sqldata.mock.MockException;
import io.gitee.jaemon.sqldata.mock.SqlConfig;
import io.gitee.jaemon.sqldata.mock.entity.Column;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class SqlExecutor {
    protected static final SqlConfig sqlConfig = SqlConfig.sqlConfig();
    protected static Connection conn;
    public static final String db;

    public static List<String> tableNames() {
        ArrayList<String> tables = new ArrayList<String>();
        try (Statement statement = conn.createStatement();
             ResultSet resultSet = statement.executeQuery(String.format("select table_name\nfrom information_schema.`TABLES`\nwhere table_schema = '%s';", db));){
            while (resultSet.next()) {
                tables.add(resultSet.getString(1));
            }
        }
        catch (Exception ex) {
            throw new MockException("");
        }
        return tables;
    }

    public static List<Column> dbColumns() {
        ArrayList<Column> tables = new ArrayList<Column>();
        try (Statement statement = conn.createStatement();
             ResultSet resultSet = statement.executeQuery(String.format("select column_name, max(column_comment) column_comment, max(column_type) column_type \nfrom information_schema.`COLUMNS`\nwhere table_schema = '%s'\ngroup by column_name;", db));){
            while (resultSet.next()) {
                tables.add(new Column(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3)));
            }
        }
        catch (Exception ex) {
            throw new MockException("");
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return tables;
    }

    public static List<String> tableColumns(String tableName) {
        String sql = String.format("select column_name, data_type\nfrom information_schema.`COLUMNS`\nwhere table_schema = '%s' and table_name = '%s';", db, tableName);
        ArrayList<String> columns = new ArrayList<String>();
        try (Statement statement = conn.createStatement();
             ResultSet resultSet = statement.executeQuery(sql);){
            while (resultSet.next()) {
                columns.add(resultSet.getString(1));
            }
        }
        catch (Exception ex) {
            throw new MockException("");
        }
        return columns;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int insert(String sql) {
        try (Statement statement = conn.createStatement();){
            int n = statement.executeUpdate(sql);
            return n;
        }
        catch (Exception e) {
            System.out.println(String.format("sql=%s, msg=%s.", sql, e.getMessage()));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int[] insertBatch(String ... sqls) {
        try {
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new MockException("");
        }
        try {
            int[] nArray;
            Object object;
            Statement statement;
            block26: {
                block27: {
                    int[] count;
                    statement = conn.createStatement();
                    object = null;
                    for (String sql : sqls) {
                        statement.addBatch(sql);
                    }
                    nArray = count = statement.executeBatch();
                    if (statement == null) break block26;
                    if (object == null) break block27;
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block26;
                }
                statement.close();
            }
            return nArray;
            catch (Throwable count) {
                try {
                    try {
                        object = count;
                        throw count;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            if (object != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable2) {
                                    ((Throwable)object).addSuppressed(throwable2);
                                }
                            } else {
                                statement.close();
                            }
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    System.out.println(String.format("msg=%s.", e.getMessage()));
                    object = new int[0];
                    return object;
                }
            }
        }
        finally {
            try {
                conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                throw new MockException("");
            }
        }
    }

    static {
        try {
            Class.forName(sqlConfig.getDriver());
            conn = DriverManager.getConnection(sqlConfig.getUrl(), sqlConfig.getUname(), sqlConfig.getPassword());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        db = sqlConfig.getDb();
    }
}

