/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.jaemon.sqldata.mock.core;

import io.gitee.jaemon.sqldata.mock.MockException;
import io.gitee.jaemon.sqldata.mock.TableColumnsHandler;
import io.gitee.jaemon.sqldata.mock.core.ColumnHandlerFactory;
import io.gitee.jaemon.sqldata.mock.core.MockTemplate;
import io.gitee.jaemon.sqldata.mock.core.SqlExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SqlDataMockExecutor
extends MockTemplate {
    public SqlDataMockExecutor(Class<? extends TableColumnsHandler> clazz) {
        super(clazz);
    }

    @Override
    List<String> tables() throws MockException {
        ArrayList<String> tables = new ArrayList<String>();
        if (SqlExecutor.sqlConfig.getIncludeTables().isEmpty()) {
            tables.addAll(SqlExecutor.tableNames());
        } else {
            tables.addAll(SqlExecutor.sqlConfig.getIncludeTables());
        }
        List<String> excludeTables = SqlExecutor.sqlConfig.getExcludeTables();
        if (!excludeTables.isEmpty()) {
            return tables.stream().filter(e -> !excludeTables.contains(e)).collect(Collectors.toList());
        }
        return tables;
    }

    @Override
    void tableSql(String table) throws MockException {
        List<String> tableColumns = SqlExecutor.tableColumns(table);
        String columns = String.join((CharSequence)",", tableColumns);
        StringBuilder insertSql = new StringBuilder();
        insertSql.append(String.format("insert into %s(%s) values", table, columns));
        StringBuilder valueSql = new StringBuilder();
        for (int i = 0; i < SqlExecutor.sqlConfig.getRecordCount(); ++i) {
            valueSql.append("(");
            for (String column : tableColumns) {
                TableColumnsHandler handler = ColumnHandlerFactory.get(column);
                Object value = null;
                if (handler != null) {
                    value = handler.generate(table);
                }
                if (String.class.isInstance(value)) {
                    valueSql.append("'" + value + "'").append(",");
                    continue;
                }
                valueSql.append(value).append(",");
            }
            valueSql.deleteCharAt(valueSql.length() - 1);
            valueSql.append("),");
        }
        valueSql.deleteCharAt(valueSql.length() - 1);
        insertSql.append((CharSequence)valueSql);
        if (SqlExecutor.sqlConfig.isTruncateTable()) {
            SqlExecutor.insertBatch(String.format("truncate table %s", table), insertSql.toString());
        } else {
            SqlExecutor.insertBatch(insertSql.toString());
        }
    }

    @Override
    public void close() throws Exception {
        SqlExecutor.conn.close();
    }
}

