/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.jaemon.sqldata.mock.core;

import io.gitee.jaemon.sqldata.mock.entity.Column;
import io.gitee.jaemon.sqldata.mock.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ColumnHandlerTool {
    private static final String CLASS_NAME = "ColumnHandlerEnum";
    private static final String HEADER = "package io.gitee.jaemon.sqldata.mock;\n\nimport io.gitee.jaemon.sqldata.mock.TableColumnsHandler;\n\npublic enum ColumnHandlerEnum implements TableColumnsHandler { \n";
    private static final String COLUMN_HANDLER_BODY = "\t// %s\t%s \n \t%s { \n \t\t@Override \n \t\tpublic Object generate(String tableName) { \n \t\t\treturn null; \n\t\t}\n\t},\n";
    private static final String FOOTER = "\t;\n\n\tColumnHandlerEnum() {\n\n\t}\n\n}";
    private static final String COLUMN_HANDLER_TEXT = "package io.gitee.jaemon.sqldata.mock;\n\nimport io.gitee.jaemon.sqldata.mock.TableColumnsHandler;\n\npublic enum ColumnHandlerEnum implements TableColumnsHandler { \n%s\t;\n\n\tColumnHandlerEnum() {\n\n\t}\n\n}";

    public static void generateColumnHandlerClass(String classPath, List<Column> columns) {
        StringBuilder columnsBody = new StringBuilder();
        for (Column column : columns) {
            columnsBody.append(String.format(COLUMN_HANDLER_BODY, column.getColumnComment(), column.getColumnType(), column.getColumnName().toUpperCase()));
        }
        if (!columns.isEmpty()) {
            columnsBody.deleteCharAt(columnsBody.lastIndexOf(","));
        }
        columnsBody.append("\n\n");
        String columnHandlerText = String.format(COLUMN_HANDLER_TEXT, columnsBody.toString());
        try {
            FileUtils.writeStringToFile(new File(classPath + File.separator + CLASS_NAME + ".java"), columnHandlerText);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

