/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.jaemon.sqldata.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class SqlConfig {
    private static final Properties sqlProperties = new Properties();
    private static final String DEFAULT_SQL_CONFIG = "sqldatamock.properties";
    public static final int DEFAULT_RECORD_COUNT = 50;
    private static SqlConfig sqlConfig;
    private String driver = "com.mysql.jdbc.Driver";
    private String url = "jdbc:mysql://127.0.0.1:3306/mockdb?useUnicode=true&characterEncoding=utf-8&useSSL=false";
    private String uname = "root";
    private String password = "root";
    private String db;
    private boolean truncateTable = false;
    private int recordCount = 50;
    private List<String> includeTables = new ArrayList<String>();
    private List<String> excludeTables = new ArrayList<String>();

    private SqlConfig() {
        try {
            String excludeTablesStr;
            sqlProperties.load(this.getClass().getClassLoader().getResourceAsStream(DEFAULT_SQL_CONFIG));
            this.driver = sqlProperties.getProperty("driver", this.driver);
            this.url = sqlProperties.getProperty("url", this.url);
            this.uname = sqlProperties.getProperty("username", this.uname);
            this.password = sqlProperties.getProperty("password", this.password);
            this.db = SqlConfig.database(this.url);
            String truncatTableFlag = sqlProperties.getProperty("truncate-table", "false");
            if ("true".equals(truncatTableFlag)) {
                this.truncateTable = true;
            }
            String recordCountStr = sqlProperties.getProperty("record-count", "50");
            this.recordCount = Integer.parseInt(recordCountStr);
            this.recordCount = this.recordCount < 0 ? 50 : (this.recordCount > 1000 ? 1000 : this.recordCount);
            String includeTablesStr = sqlProperties.getProperty("include-tables");
            if (SqlConfig.isNotEmpty(includeTablesStr)) {
                this.includeTables = Arrays.asList(includeTablesStr.split(","));
            }
            if (SqlConfig.isNotEmpty(excludeTablesStr = sqlProperties.getProperty("exclude-tables"))) {
                this.excludeTables = Arrays.asList(excludeTablesStr.split(","));
            }
            SqlConfig.print("url=%s", this.url);
            SqlConfig.print("username=%s", this.uname);
            SqlConfig.print("password=%s", this.password);
            SqlConfig.print("truncateTable=%s", this.truncateTable);
            SqlConfig.print("recordCount=%s", this.recordCount);
        }
        catch (Exception ex) {
            SqlConfig.print("\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", new Object[0]);
        }
    }

    public static SqlConfig sqlConfig() {
        if (sqlConfig == null) {
            sqlConfig = new SqlConfig();
        }
        return sqlConfig;
    }

    private static String database(String url) {
        int start = url.lastIndexOf(47) + 1;
        int end = url.lastIndexOf(63);
        return url.substring(start, end);
    }

    private static boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    private static void print(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    private static boolean isNotEmpty(String str) {
        return !SqlConfig.isEmpty(str);
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUname() {
        return this.uname;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDb() {
        return this.db;
    }

    public boolean isTruncateTable() {
        return this.truncateTable;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public List<String> getIncludeTables() {
        return this.includeTables;
    }

    public List<String> getExcludeTables() {
        return this.excludeTables;
    }
}

