/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.sqldata.mock.utils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Random;

/**
 * mock工具类
 *
 * @author Jaemon
 * @since 1.0
 */
public class MockRandomUtils {

    private static final char[] UPPER_CASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] LOWER_CASE = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] UPPER_LOWER_CASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] NUM_CASE = "0123456789".toCharArray();
    private static final char[] ID_LAST_THREE_CASE = "0123456789x".toCharArray();
    private static final char[] CHAR_NUM_CASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    private static final String CONNECTOR = "-";

    public static final Random random = new Random();
    public static final DateTimeFormatter DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");


    /**
     * 随机生成长度为n的字母字符串
     *
     * @param length
     *      字符串长度
     * @return
     *      字母字符串内容
     */
    public static String generateChars(int length) {
        return generate(UPPER_LOWER_CASE, length);
    }


    /**
     * 随机生成长度为n的数字字符串
     *
     * @param length
     *      字符串长度
     * @return
     *      数字字符串内容
     */
    public static String generateNums(int length) {
        return generate(NUM_CASE, length);
    }


    /**
     * 随机生成长度为n的字符串
     *
     * @param length
     *      字符串长度
     * @return
     *      字符串内容
     */
    public static String generateCharNums(int length) {
        return generate(CHAR_NUM_CASE, length);
    }


    /**
     * 随机生成日期字符串
     *
     * @param connector
     *      是否需要连接符
     * @return
     *      日期
     */
    public static String date(boolean connector) {
        int yearBound = LocalDate.now().getYear() - 1700;
        int year = random.nextInt(yearBound) + 1700;
        int month = random.nextInt(12) + 1;
        String monthVal = month < 10 ? "0" + month : String.valueOf(month);
        int dayBound = month == 2 ? (year % 4 == 0) ? 28 : 29 : 30;
        int day = random.nextInt(dayBound) + 1;
        String dayVal = day < 10 ? "0" + day : String.valueOf(day);
        if (connector) {
            return year + CONNECTOR + monthVal + CONNECTOR + dayVal;
        } else {
            return year + monthVal + dayVal;
        }
    }

    /**
     * 随机生成身份证
     *
     * @return
     *      身份证号
     */
    public static String idNo() {
        StringBuilder result = new StringBuilder(18);
        result.append(intRandom(CityCode.cities));
        result.append(date(false));
        result.append(generateNums(3));
        result.append(generate(ID_LAST_THREE_CASE, 1));
        return result.toString();
    }


    /**
     * 从int数组中随机获取元素
     *
     * @param ints
     *      数组内容
     * @return
     *      随机元素
     */
    public static int intRandom(int[] ints) {
        return ints[random.nextInt(ints.length)];
    }

    /**
     * 从字符串数组中随机获取元素
     *
     * @param stirngs
     *      数组内容
     * @return
     *      随机元素
     */
    public static String stringRandom(String[] stirngs) {
        return stirngs[random.nextInt(stirngs.length)];
    }

    /**
     * 随机生成长度为length的字符串
     *
     * @param source
     *          数据源
     * @param length
     *          字符串长度长度
     * @return
     *          字符串内容
     */
    private static String generate(char[] source, int length) {
        StringBuilder result = new StringBuilder(length);

        for (int i = 0; i < length; i++) {
            int index = random.nextInt(source.length);
            result.append(source[index]);
        }

        return result.toString();
    }



    public static void main(String[] args) {

        for (int i = 0; i < 10; i++) {
            System.out.println(idNo());
//            System.out.println(generateNums(32));
//            System.out.println(random.nextFloat() * 100000);
        }

    }


}