/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.sqldata.mock.core;

import io.gitee.jaemon.sqldata.mock.MockException;
import io.gitee.jaemon.sqldata.mock.TableColumnsHandler;

import java.util.List;

/**
 * 数据mock模板类
 *
 * @author Jaemon
 * @since 1.0
 */
public abstract class MockTemplate implements AutoCloseable {
    protected static final String INSERT_PREFIX = "insert into %s(%s) values";

    public MockTemplate(Class<? extends TableColumnsHandler> clazz) {
        ColumnHandlerFactory.register(clazz);
    }

    /**
     * mock
     *
     * @throws MockException
     *      ex
     */
    public void mock() throws MockException {
        List<String> tables = tables();

        for (String table : tables) {
            tableSql(table);
        }
    }

    /**
     * 获取所有表名
     *
     * @return
     *      表名集
     * @throws MockException
     *      ex
     */
    abstract List<String> tables() throws MockException;

    /**
     * 表处理
     *
     * @param table
     *      表名
     * @throws MockException
     *      ex
     */
    abstract void tableSql(String table) throws MockException;
}