/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.sqldata.mock.core;

import io.gitee.jaemon.sqldata.mock.entity.Column;
import io.gitee.jaemon.sqldata.mock.utils.FileUtils;

import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * 字段处理工具
 *
 * @author Jaemon
 * @since 1.0
 */
public class ColumnHandlerTool {
    private static final String CLASS_NAME = "ColumnHandlerEnum";

    private static final String HEADER = "" +
            "package io.gitee.jaemon.sqldata.mock;\n\n" +
            "import io.gitee.jaemon.sqldata.mock.TableColumnsHandler;\n\n" +
            "public enum " + CLASS_NAME + " implements TableColumnsHandler { \n";

    private static final String COLUMN_HANDLER_BODY = "\t" +
            "// %s\t%s \n \t" +
            "%s { \n \t\t" +
                "@Override \n \t\t" +
                "public Object generate(String tableName) { \n \t\t\t" +
                    "return null; \n\t\t" +
                "}\n\t" +
            "},\n";

    private static final String FOOTER = "\t;\n\n\t" + CLASS_NAME + "() {\n\n\t}\n\n}";

    private static final String COLUMN_HANDLER_TEXT = HEADER  + "%s" + FOOTER;

    /**
     * 生成字段处理类
     *
     * @param classPath
     *      类生成路径, /home/jaemon
     * @param columns
     *      字段集
     */
    public static void generateColumnHandlerClass(String classPath, List<Column> columns) {
        StringBuilder columnsBody =  new StringBuilder();
        for (Column column : columns) {
            columnsBody.append(
                    String.format(
                            COLUMN_HANDLER_BODY,
                            column.getColumnComment(),
                            column.getColumnType(),
                            column.getColumnName().toUpperCase()
                    )
            );
        }

        if (!columns.isEmpty()) {
            columnsBody.deleteCharAt(columnsBody.lastIndexOf(","));
        }
        columnsBody.append("\n\n");


        String columnHandlerText = String.format(COLUMN_HANDLER_TEXT, columnsBody.toString());
        try {
            FileUtils.writeStringToFile(
                    new File(classPath + File.separator + CLASS_NAME + ".java"), columnHandlerText
            );
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}