/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.sqldata.mock.core;

import io.gitee.jaemon.sqldata.mock.MockException;
import io.gitee.jaemon.sqldata.mock.TableColumnsHandler;

import java.util.HashMap;
import java.util.Map;

/**
 * 表字段处理工厂类
 *
 * @author Jaemon
 * @since 1.0
 */
public class ColumnHandlerFactory {
    private static final Map<String, TableColumnsHandler> container = new HashMap<>();

    static void register(Class<? extends TableColumnsHandler> clazz) {
        if (clazz.isEnum()) {
            TableColumnsHandler[] enumConstants = clazz.getEnumConstants();
            for (TableColumnsHandler handler : enumConstants) {
                container.put(handler.name().toLowerCase(), handler);
            }
        } else {
            throw new MockException("class=%s必须是枚举类", clazz.getName());
        }
    }

    static TableColumnsHandler get(String key) {
        return container.get(key.toLowerCase());
    }
}