/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.sqldata.mock;

import io.gitee.jaemon.sqldata.mock.core.ColumnHandlerTool;
import io.gitee.jaemon.sqldata.mock.core.MockTemplate;
import io.gitee.jaemon.sqldata.mock.core.SqlDataMockExecutor;
import io.gitee.jaemon.sqldata.mock.core.SqlExecutor;
import io.gitee.jaemon.sqldata.mock.entity.Column;

import java.util.List;


/**
 * 数据mock启动类
 *
 * @author Jaemon
 * @since 1.0
 */
public class DataMockStarter {

    /**
     * mock表数据
     *
     * @param clazz
     *          表字段处理类
     */
    public static void mock(Class<? extends TableColumnsHandler> clazz) {
        try (MockTemplate mockTemplate = new SqlDataMockExecutor(clazz)) {
            mockTemplate.mock();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /**
     * 生成字段处理类
     *
     * @param filePath
     *      类生成路径, /home/jaemon
     */
    public static void columnHandlerClass(String filePath) {
        List<Column> dbColumns = SqlExecutor.dbColumns();

        ColumnHandlerTool.generateColumnHandlerClass(filePath, dbColumns);
    }


    public static void main(String[] args) {
        if (args.length == 0) {
            return;
        }

        String className = args[0];
        Class<? extends TableColumnsHandler> clazz =
                null;
        try {
            clazz = (Class<? extends TableColumnsHandler>) Class.forName(className);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        mock(clazz);
    }

}