<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE mapper PUBLIC "-//mybatis.org//DTD Mapper 3.0//EN" "http://mybatis.org/dtd/mybatis-3-mapper.dtd">
<#assign
	basePackage=templateContext.basePackage,
	UpperName=tableDefinition.modelName,
	tableName=tableDefinition.tableName,
	entityClass=basePackage+'.'+entity+'.'+UpperName
/>
<mapper namespace="${basePackage}.${mapper}.${UpperName}Mapper">
	<sql id="${UpperName}Columns">
	<#assign columns=tableDefinition.columns, primaryKeys=tableDefinition.primaryKeys />
	<#if (columns?? && columns?size > 0)>
		<#list columns as column>${column.columnName}<#if column_has_next>, </#if></#list>
	</#if>
	</sql>


	<select id="queryList" resultType="${entityClass}">
		select <include refid="${UpperName}Columns" />
		from ${tableName}
	<#if (columns?? && columns?size > 0)>
		<where>
		<#list columns as column>
			<if test="${column.propertyName} != null and ${column.propertyName} != ''">
				and ${column.columnName} = ${"#{" + column.propertyName + "}"}
			</if>
		</#list>
		</where>
	</#if>
	</select>

	<select id="queryByPrimaryKey" resultType="${entityClass}">
		select <include refid="${UpperName}Columns" />
		from ${tableName}
	<#if (primaryKeys?? && primaryKeys?size > 0)>
		where <#list primaryKeys as primaryKey>${primaryKey.columnName} = ${"#{" + primaryKey.propertyName + "}"}<#if primaryKey_has_next> and </#if></#list>
	</#if>
	</select>

	<insert id="insert" parameterType="${entityClass}">
		insert into ${tableName}( <include refid="${UpperName}Columns" /> )
		values (
		<#if (columns?? && columns?size > 0)>
			<#list columns as column>${"#{" + column.propertyName + "}"}<#if column_has_next>, </#if></#list>
		</#if>
		)
	</insert>

	<insert id="batchInsert">
		insert into ${tableName}( <include refid="${UpperName}Columns" /> )
		values
		<foreach collection="list" item="item" index="index" separator=",">
			(
			<#if (columns?? && columns?size > 0)>
				<#list columns as column>${"#{" + 'item.' + column.propertyName + "}"}<#if column_has_next>, </#if></#list>
			</#if>
			)
		</foreach>
	</insert>

	<update id="update" parameterType="${entityClass}">
		update ${tableName}
	<#if (columns?? && columns?size > 0)>
		<trim prefix="set" suffixOverrides=",">
		<#list columns as column>
			<if test="${column.propertyName} != null and ${column.propertyName} != ''">
				${column.columnName} = ${"#{" + column.propertyName + "}"},
			</if>
		</#list>
		</trim>
	<#if (primaryKeys?? && primaryKeys?size > 0)>
		where <#list primaryKeys as primaryKey>${primaryKey.columnName} = ${"#{" + primaryKey.propertyName + "}"}<#if primaryKey_has_next> and </#if></#list>
	</#if>
	</#if>
	</update>

	<delete id="deleteByPrimaryKey">
		delete from ${tableName}
	<#if (primaryKeys?? && primaryKeys?size > 0)>
		where <#list primaryKeys as primaryKey>${primaryKey.columnName} = ${"#{" + primaryKey.propertyName + "}"}<#if primaryKey_has_next> and </#if></#list>
	</#if>
	</delete>
</mapper>
<#flush />