/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.utils;

import java.util.HashMap;
import java.util.Map;

/**
 * 行政区划代码映射
 *
 * @author Jaemon
 * @version 1.0
 */
public class IdCardRecognition {
    public static final Map<String, String[]> map = new HashMap<>(1024);
    public static final String KEY_SEPERATOR = "_";
    public static final String VALUE_SEPERATOR = "\\|";
    public static final String PROVINCE_KEY = "0";

    static {
        new IdCardRecognition();
    }

    private IdCardRecognition() {
        map.put("0_0", new String[]{"东城区|110101","西城区|110102","崇文区|110103","宣武区|110104","朝阳区|110105","丰台区|110106","石景山区|110107","海淀区|110108","门头沟区|110109","燕山区|110110","房山区|110111","通州区|110112","顺义区|110113","昌平区|110114","大兴区|110115","怀柔区|110116","平谷区|110117","昌平县|110221","顺义县|110222","通县|110223","大兴县|110224","房山县|110225","平谷县|110226","怀柔县|110227","密云县|110228","延庆县|110229"});
        map.put("0_1", new String[]{"和平区|120101","河东区|120102","河西区|120103","南开区|120104","河北区|120105","红桥区|120106","塘沽区|120107","汉沽区|120108","大港区|120109","东丽区|120110","西青区|120111","津南区|120112","北辰区|120113","武清区|120114","宝坻区|120115","宁河县|120221","武清县|120222","静海县|120223","宝坻县|120224","蓟县|120225"});
        map.put("0_2_0", new String[]{"市辖区|130101","长安区|130102","桥东区|130103","桥西区|130104","新华区|130105","郊区|130106","井陉矿区|130107","裕华区|130108","井陉县|130121","获鹿县|130122","正定县|130123","栾城县|130124","行唐县|130125","灵寿县|130126","高邑县|130127","深泽县|130128","赞皇县|130129","无极县|130130","平山县|130131","元氏县|130132","赵县|130133","辛集市|130181","藁城市|130182","晋州市|130183","新乐市|130184","鹿泉市|130185"});
        map.put("0_2_1", new String[]{"市辖区|130201","路南区|130202","路北区|130203","古冶区|130204","开平区|130205","新区|130206","丰南区|130207","丰润区|130208","丰润县|130221","丰南县|130222","滦县|130223","滦南县|130224","乐亭县|130225","迁安县|130226","迁西县|130227","遵化县|130228","玉田县|130229","唐海县|130230","遵化市|130281","丰南市|130282","迁安市|130283"});
        map.put("0_2_2", new String[]{"市辖区|130301","海港区|130302","山海关区|130303","北戴河区|130304","青龙满族自治县|130321","昌黎县|130322","抚宁县|130323","卢龙县|130324"});
        map.put("0_2_3", new String[]{"市辖区|130401","邯山区|130402","丛台区|130403","复兴区|130404","郊区|130405","峰峰矿区|130406","邯郸县|130421","武安县|130422","临漳县|130423","成安县|130424","大名县|130425","涉县|130426","磁县|130427","肥乡县|130428","永年县|130429","邱县|130430","鸡泽县|130431","广平县|130432","馆陶县|130433","魏县|130434","曲周县|130435","武安市|130481"});
        map.put("0_2_4", new String[]{"市辖区|130501","桥东区|130502","桥西区|130503","邢台县|130521","临城县|130522","内丘县|130523","柏乡县|130524","隆尧县|130525","任县|130526","南和县|130527","宁晋县|130528","巨鹿县|130529","新河县|130530","广宗县|130531","平乡县|130532","威县|130533","清河县|130534","临西县|130535","南宫市|130581","沙河市|130582"});
        map.put("0_2_5", new String[]{"市辖区|130601","新市区|130602","北市区|130603","南市区|130604","满城县|130621","清苑县|130622","涞水县|130623","阜平县|130624","徐水县|130625","定兴县|130626","唐县|130627","高阳县|130628","容城县|130629","涞源县|130630","望都县|130631","安新县|130632","易县|130633","曲阳县|130634","蠡县|130635","顺平县|130636","博野县|130637","雄县|130638","涿州市|130681","定州市|130682","安国市|130683","高碑店市|130684"});
        map.put("0_2_6", new String[]{"市辖区|130701","桥东区|130702","桥西区|130703","宣化区|130705","下花园区|130706","宣化县|130721","张北县|130722","康保县|130723","沽源县|130724","尚义县|130725","蔚县|130726","阳原县|130727","怀安县|130728","万全县|130729","怀来县|130730","涿鹿县|130731","赤城县|130732","崇礼县|130733"});
        map.put("0_2_7", new String[]{"市辖区|130801","双桥区|130802","双滦区|130803","鹰手营子矿区|130804","承德县|130821","兴隆县|130822","平泉县|130823","滦平县|130824","隆化县|130825","丰宁满族自治县|130826","宽城满族自治县|130827","围场满族蒙古族自治县|130828"});
        map.put("0_2_8", new String[]{"市辖区|130901","新华区|130902","运河区|130903","郊区|130904","沧县|130921","青县|130922","东光县|130923","海兴县|130924","盐山县|130925","肃宁县|130926","南皮县|130927","吴桥县|130928","献县|130929","孟村回族自治县|130930","泊头市|130981","任丘市|130982","黄骅市|130983","河间市|130984"});
        map.put("0_2_9", new String[]{"市辖区|131001","安次区|131002","广阳区|131003","三河县|131021","固安县|131022","永清县|131023","香河县|131024","大城县|131025","文安县|131026","霸县|131027","大厂回族自治县|131028","霸州市|131081","三河市|131082"});
        map.put("0_2_10", new String[]{"市辖区|131101","桃城区|131102","枣强县|131121","武邑县|131122","武强县|131123","饶阳县|131124","安平县|131125","故城县|131126","景县|131127","阜城县|131128","冀州市|131181","深州市|131182"});
        map.put("0_2_11", new String[]{"邯郸市|132101","大名县|132121","魏县|132122","曲周县|132123","丘县|132124","鸡泽县|132125","肥乡县|132126","广平县|132127","成安县|132128","临漳县|132129","磁县|132130","武安县|132131","涉县|132132","永年县|132133","邯郸县|132134","馆陶县|132135"});
        map.put("0_2_12", new String[]{"南宫市|132201","沙河市|132202","邢台县|132221","沙河县|132222","临城县|132223","内丘县|132224","柏乡县|132225","隆尧县|132226","任县|132227","南和县|132228","宁晋县|132229","南宫县|132230","巨鹿县|132231","新河县|132232","广宗县|132233","平乡县|132234","威县|132235","清河县|132236","临西县|132237"});
        map.put("0_2_13", new String[]{"辛集市|132301","藁城市|132302","束鹿县|132321","晋县|132322","深泽县|132323","无极县|132324","藁城县|132325","赵县|132326","栾城县|132327","正定县|132328","新乐县|132329","高邑县|132330","元氏县|132331","赞皇县|132332","井陉县|132333","获鹿县|132334","平山县|132335","灵寿县|132336","行唐县|132337"});
        map.put("0_2_14", new String[]{"定州市|132401","涿州市|132402","安国市|132403","高碑店市|132404","易县|132421","满城县|132422","徐水县|132423","涞源县|132424","定兴县|132425","完县|132426","唐县|132427","望都县|132428","涞水县|132429","涿县|132430","清苑县|132431","高阳县|132432","安新县|132433","雄县|132434","容城县|132435","新城县|132436","曲阳县|132437","阜平县|132438","定县|132439","安国县|132440","博野县|132441","蠡县|132442"});
        map.put("0_2_15", new String[]{"张家口市|132501","张北市|132521","康保县|132522","沽源县|132523","尚义县|132524","蔚县|132525","阳原县|132526","怀安县|132527","万全县|132528","怀来县|132529","涿鹿县|132530","宣化县|132531","赤城县|132532","崇礼县|132533"});
        map.put("0_2_16", new String[]{"承德市|132601","青龙县|132621","宽城满族自治县|132622","兴隆县|132623","平泉县|132624","承德县|132625","滦平县|132626","丰宁满族自治县|132627","隆化县|132628","围场满族蒙古族自治县|132629"});
        map.put("0_2_17", new String[]{"廊坊市|132801","三河县|132821","大厂回族自治县|132822","香河县|132823","永清县|132825","固安县|132826","霸县|132827","文安县|132828","大城县|132829"});
        map.put("0_2_18", new String[]{"沧州市|132901","泊头市|132902","任丘市|132903","黄骅市|132904","河间市|132905","沧县|132921","河间县|132922","肃宁县|132923","献县|132924","交河县|132925","吴桥县|132926","东光县|132927","南皮县|132928","盐山县|132929","黄骅县|132930","孟村回族自治县|132931","青县|132932","任丘县|132933","海兴县|132934"});
        map.put("0_2_19", new String[]{"衡水市|133001","冀州市|133002","衡水县|133021","冀县|133022","枣强县|133023","武邑县|133024","深县|133025","武强县|133026","饶阳县|133027","安平县|133028","故城县|133029","景县|133030","阜城县|133031"});
        map.put("0_2", new String[]{"石家庄市|130100","唐山市|130200","秦皇岛市|130300","邯郸市|130400","邢台市|130500","保定市|130600","张家口市|130700","承德市|130800","沧州市|130900","廊坊市|131000","衡水市|131100","邯郸地区|132100","邢台地区|132200","石家庄市|132300","保定地区|132400","张家口地区|132500","承德地区|132600","廊坊地区|132800","沧州地区|132900","衡水地区|133000","武安市|139001"});
        map.put("0_3_0", new String[]{"市辖区|140101","南城区|140102","北城区|140103","河西区|140104","小店区|140105","迎泽区|140106","杏花岭区|140107","尖草坪区|140108","万柏林区|140109","晋源区|140110","古交工矿区|140111","南郊区|140112","北郊区|140113","清徐县|140121","阳曲县|140122","娄烦县|140123","古交市|140181"});
        map.put("0_3_1", new String[]{"市辖区|140201","城区|140202","矿区|140203","南郊区|140211","新荣区|140212","阳高县|140221","天镇县|140222","广灵县|140223","灵丘县|140224","浑源县|140225","左云县|140226","大同县|140227","左云县|140230","大同县|140232"});
        map.put("0_3_2", new String[]{"市辖区|140301","城区|140302","矿区|140303","郊区|140311","平定县|140321","盂县|140322"});
        map.put("0_3_3", new String[]{"市辖区|140401","城区|140402","郊区|140411","长治县|140421","襄垣县|140423","屯留县|140424","平顺县|140425","黎城县|140426","壶关县|140427","长子县|140428","武乡县|140429","沁县|140430","沁源县|140431","潞城市|140481"});
        map.put("0_3_4", new String[]{"市辖区|140501","城区|140502","郊区|140511","沁水县|140521","阳城县|140522","高平县|140523","陵川县|140524","泽州县|140525","高平市|140581"});
        map.put("0_3_5", new String[]{"市辖区|140601","朔城区|140602","平鲁区|140603","山阴县|140621","应县|140622","右玉县|140623","怀仁县|140624"});
        map.put("0_3_6", new String[]{"市辖区|140701","榆次区|140702","榆社县|140721","左权县|140722","和顺县|140723","昔阳县|140724","寿阳县|140725","太谷县|140726","祁县|140727","平遥县|140728","灵石县|140729","介休市|140781"});
        map.put("0_3_7", new String[]{"市辖区|140801","盐湖区|140802","临猗县|140821","万荣县|140822","闻喜县|140823","稷山县|140824","新绛县|140825","绛县|140826","垣曲县|140827","夏县|140828","平陆县|140829","芮城县|140830","永济市|140881","河津市|140882"});
        map.put("0_3_8", new String[]{"市辖区|140901","忻府区|140902","定襄县|140921","五台县|140922","代县|140923","繁峙县|140924","宁武县|140925","静乐县|140926","神池县|140927","五寨县|140928","岢岚县|140929","河曲县|140930","保德县|140931","偏关县|140932","原平市|140981"});
        map.put("0_3_9", new String[]{"市辖区|141001","尧都区|141002","曲沃县|141021","翼城县|141022","襄汾县|141023","洪洞县|141024","古县|141025","安泽县|141026","浮山县|141027","吉县|141028","乡宁县|141029","大宁县|141030","隰县|141031","永和县|141032","蒲县|141033","汾西县|141034","侯马市|141081","霍州市|141082"});
        map.put("0_3_10", new String[]{"市辖区|141101","离石区|141102","文水县|141121","交城县|141122","兴县|141123","临县|141124","柳林县|141125","石楼县|141126","岚县|141127","方山县|141128","中阳县|141129","交口县|141130","孝义市|141181","汾阳市|141182"});
        map.put("0_3_11", new String[]{"阳高县|142121","天镇县|142122","广灵县|142123","灵丘县|142124","浑源县|142125","应县|142126","山阴县|142127","朔县|142128","平鲁县|142129","左云县|142130","右玉县|142131","大同县|142132","怀仁县|142133"});
        map.put("0_3_12", new String[]{"忻州市|142201","原平市|142202","定襄县|142222","五台县|142223","代县|142225","繁峙县|142226","宁武县|142227","静乐县|142228","神池县|142229","五寨县|142230","岢岚县|142231","河曲县|142232","保德县|142233","偏关县|142234"});
        map.put("0_3_13", new String[]{"孝义市|142301","离石市|142302","汾阳市|142303","汾阳县|142321","文水县|142322","交城县|142323","兴县|142325","临县|142326","柳林县|142327","石楼县|142328","岚县|142329","方山县|142330","中阳县|142332","交口县|142333"});
        map.put("0_3_14", new String[]{"榆次市|142401","介休市|142402","榆社县|142421","左权县|142422","和顺县|142423","昔阳县|142424","寿阳县|142427","太谷县|142429","祁县|142430","平遥县|142431","灵石县|142433"});
        map.put("0_3_15", new String[]{"临汾市|142601","侯马市|142602","霍州市|142603","曲沃县|142621","翼城县|142622","襄汾县|142623","洪洞县|142625","古县|142627","安泽县|142628","浮山县|142629","吉县|142630","乡宁县|142631","蒲县|142632","大宁县|142633","永和县|142634","隰县|142635","汾西县|142636"});
        map.put("0_3_16", new String[]{"运城市|142701","永济市|142702","河津市|142703","芮城县|142723","临猗县|142724","万荣县|142725","新绛县|142726","稷山县|142727","闻喜县|142729","夏县|142730","绛县|142731","平陆县|142732","垣曲县|142733"});
        map.put("0_3", new String[]{"太原市|140100","大同市|140200","阳泉市|140300","长治市|140400","晋城市|140500","朔州市|140600","晋中市|140700","运城市|140800","忻州市|140900","临汾市|141000","吕梁市|141100","雁北地区|142100","忻州地区|142200","吕梁地区|142300","晋中地区|142400","临汾地区|142600","运城地区|142700","古交市|149001"});
        map.put("0_4_0", new String[]{"市辖区|150101","新城区|150102","回民区|150103","玉泉区|150104","郊区|150105","土默特左旗|150121","托克托县|150122","和林格尔县|150123","清水河县|150124","武川县|150125"});
        map.put("0_4_1", new String[]{"市辖区|150201","东河区|150202","昆都伦区|150203","青山区|150204","石拐矿区|150205","白云矿区|150206","郊区|150207","土默特右旗|150221","固阳县|150222","达尔罕茂明安联合旗|150223"});
        map.put("0_4_2", new String[]{"市辖区|150301","海勃湾区|150302","海南区|150303","乌达区|150304"});
        map.put("0_4_3", new String[]{"市辖区|150401","红山区|150402","元宝山区|150403","松山区|150404","阿鲁科尔沁旗|150421","巴林左旗|150422","巴林右旗|150423","林西县|150424","克什克腾旗|150425","翁牛特旗|150426","喀喇沁旗|150428","宁城县|150429","敖汉旗|150430"});
        map.put("0_4_4", new String[]{"市辖区|150501","科尔沁区|150502","科尔沁左翼中旗|150521","科尔沁左翼后旗|150522","开鲁县|150523","库伦旗|150524","奈曼旗|150525","扎鲁特旗|150526","霍林郭勒市|150581"});
        map.put("0_4_5", new String[]{"鄂尔多斯市|150601","东胜区|150602","达拉特旗|150621","准格尔旗|150622","鄂托克前旗|150623","鄂托克旗|150624","杭锦旗|150625","乌审旗|150626","伊金霍洛旗|150627"});
        map.put("0_4_6", new String[]{"市辖区|150701","海拉尔区|150702","阿荣旗|150721","莫力达瓦达斡尔族自治旗|150722","鄂伦春自治旗|150723","鄂温克族自治旗|150724","陈巴尔虎旗|150725","新巴尔虎左旗|150726","新巴尔虎右旗|150727","满洲里市|150781","牙克石市|150782","扎兰屯市|150783","额尔古纳市|150784","根河市|150785"});
        map.put("0_4_7", new String[]{"市辖区|150801","临河区|150802","五原县|150821","磴口县|150822","乌拉特前旗|150823","乌拉特中旗|150824","乌拉特后旗|150825","杭锦后旗|150826"});
        map.put("0_4_8", new String[]{"市辖区|150901","集宁区|150902","卓资县|150921","化德县|150922","商都县|150923","兴和县|150924","凉城县|150925","察哈尔右翼前旗|150926","察哈尔右翼中旗|150927","察哈尔右翼后旗|150928","四子王旗|150929","丰镇市|150981"});
        map.put("0_4_9", new String[]{"海拉尔市|152101","满洲里市|152102","扎兰屯市|152103","牙克石市|152104","根河市|152105","额尔古纳市|152106","布特哈旗|152121","阿荣旗|152122","莫力达瓦达斡尔族自治旗|152123","喜桂图旗|152124","额尔古纳右旗|152125","额尔古纳左旗|152126","鄂伦春自治旗|152127","鄂温克族自治旗|152128","新巴尔虎右旗|152129","新巴尔虎左旗|152130","陈巴尔虎旗|152131"});
        map.put("0_4_10", new String[]{"乌兰浩特市|152201","阿尔山市|152202","科尔沁右翼前旗|152221","科尔沁右翼中旗|152222","扎赉特旗|152223","突泉县|152224"});
        map.put("0_4_11", new String[]{"通辽市|152301","霍林郭勒市|152302","通辽县|152321","科尔沁左翼中旗|152322","科尔沁左翼后旗|152323","开鲁县|152324","库伦旗|152325","奈曼旗|152326","扎鲁特旗|152327"});
        map.put("0_4_12", new String[]{"二连浩特市|152501","锡林浩特市|152502","阿巴嘎旗|152522","苏尼特左旗|152523","苏尼特右旗|152524","东乌珠穆沁旗|152525","西乌珠穆沁旗|152526","太仆寺旗|152527","镶黄旗|152528","正镶白旗|152529","正蓝旗|152530","多伦县|152531"});
        map.put("0_4_13", new String[]{"集宁市|152601","丰镇市|152602","武川县|152621","和林格尔县|152622","清水河县|152623","卓资县|152624","化德县|152625","商都县|152626","兴和县|152627","丰镇县|152628","凉城县|152629","察哈尔右翼前旗|152630","察哈尔右翼中旗|152631","察哈尔右翼后旗|152632","达尔罕茂明安联合旗|152633","四子王旗|152634"});
        map.put("0_4_14", new String[]{"东胜市|152701","东胜县|152721","达拉特旗|152722","准格尔旗|152723","鄂托克前旗|152724","鄂托克旗|152725","杭锦旗|152726","乌审旗|152727","伊金霍洛旗|152728"});
        map.put("0_4_15", new String[]{"临河市|152801","临河县|152821","五原县|152822","磴口县|152823","乌拉特前旗|152824","乌拉特中旗|152825","乌拉特后旗|152826","杭锦后旗|152827"});
        map.put("0_4_16", new String[]{"阿拉善左旗|152921","阿拉善右旗|152922","额济纳旗|152923"});
        map.put("0_4", new String[]{"呼和浩特市|150100","包头市|150200","乌海市|150300","赤峰市|150400","通辽市|150500","鄂尔多斯市|150600","呼伦贝尔市|150700","巴彦淖尔市|150800","乌兰察布市|150900","呼伦贝尔盟|152100","兴安盟|152200","哲里木盟|152300","锡林郭勒盟|152500","乌兰察布盟|152600","伊克昭盟|152700","巴彦淖尔盟|152800","阿拉善盟|152900"});
        map.put("0_5_0", new String[]{"市辖区|210101","和平区|210102","沈河区|210103","大东区|210104","皇姑区|210105","铁西区|210106","苏家屯区|210111","东陵区|210112","沈北新区|210113","于洪区|210114","市区|210120","新民县|210121","辽中县|210122","康平县|210123","法库县|210124","新民市|210181"});
        map.put("0_5_1", new String[]{"市辖区|210201","中山区|210202","西岗区|210203","沙河口区|210204","甘井子区|210211","旅顺口区|210212","金州区|210213","瓦房店市|210219","市区|210220","金县|210221","新金县|210222","复县|210223","长海县|210224","庄河县|210225","瓦房店市|210281","普兰店市|210282","庄河市|210283"});
        map.put("0_5_2", new String[]{"市辖区|210301","铁东区|210302","铁西区|210303","立山区|210304","千山区|210311","开发区|210319","台安县|210321","岫岩满族自治县|210323","海城市|210381"});
        map.put("0_5_3", new String[]{"市辖区|210401","新抚区|210402","东洲区|210403","望花区|210404","顺城区|210411","抚顺县|210421","新宾满族自治县|210422","清原满族自治县|210423"});
        map.put("0_5_4", new String[]{"市辖区|210501","平山区|210502","溪湖区|210503","明山区|210504","南芬区|210505","南芬区|210511","本溪满族自治县|210521","桓仁满族自治县|210522"});
        map.put("0_5_5", new String[]{"市辖区|210601","元宝区|210602","振兴区|210603","振安区|210604","市区|210620","凤城满族自治县|210621","岫岩满族自治县|210622","东沟县|210623","宽甸满族自治县|210624","东港市|210681","凤城市|210682"});
        map.put("0_5_6", new String[]{"市辖区|210701","古塔区|210702","凌河区|210703","南票区|210704","葫芦岛区|210705","太和区|210711","锦西市|210719","市区|210720","锦西县|210721","兴城县|210722","绥中县|210723","锦县|210724","北镇满族自治县|210725","黑山县|210726","义县|210727","凌海市|210781","北镇市|210782"});
        map.put("0_5_7", new String[]{"市辖区|210801","站前区|210802","西市区|210803","鲅鱼圈区|210804","老边区|210811","营口县|210821","盖县|210824","盖州市|210881","大石桥市|210882"});
        map.put("0_5_8", new String[]{"市辖区|210901","海州区|210902","新邱区|210903","太平区|210904","清河门区|210905","细河区|210911","阜新蒙古族自治县|210921","彰武县|210922"});
        map.put("0_5_9", new String[]{"市辖区|211001","白塔区|211002","文圣区|211003","宏伟区|211004","弓长岭区|211005","太子河区|211011","辽阳县|211021","灯塔县|211022","灯塔市|211081"});
        map.put("0_5_10", new String[]{"市辖区|211101","双台子区|211102","兴隆台区|211103","郊区|211111","大洼县|211121","盘山县|211122"});
        map.put("0_5_11", new String[]{"市辖区|211201","银州区|211202","铁法区|211203","清河区|211204","铁岭县|211221","开原县|211222","西丰县|211223","昌图县|211224","康平县|211225","法库县|211226","调兵山市|211281","开原市|211282"});
        map.put("0_5_12", new String[]{"市辖区|211301","双塔区|211302","龙城区|211303","朝阳县|211321","建平县|211322","凌源县|211323","喀喇沁左翼蒙古族自治县|211324","建昌县|211325","北票县|211326","北票市|211381","凌源市|211382"});
        map.put("0_5_13", new String[]{"市辖区|211401","连山区|211402","龙港区|211403","南票区|211404","绥中县|211421","建昌县|211422","兴城市|211481"});
        map.put("0_5_14", new String[]{"铁岭市|212101","铁法市|212102","铁岭县|212121","开原县|212122","西丰县|212123","昌图县|212124","康平县|212125","法库县|212126"});
        map.put("0_5_15", new String[]{"建昌县|212225","北票县|212226"});
        map.put("0_5", new String[]{"沈阳市|210100","大连市|210200","鞍山市|210300","抚顺市|210400","本溪市|210500","丹东市|210600","锦州市|210700","营口市|210800","阜新市|210900","辽阳市|211000","盘锦市|211100","铁岭市|211200","朝阳市|211300","葫芦岛市|211400","铁岭市|212100","朝阳市|212200","瓦房店市|219001","海城市|219002","锦西市|219003","兴城市|219004","铁法市|219005","北票市|219006","开原市|219007"});
        map.put("0_6_0", new String[]{"市辖区|220101","南关区|220102","宽城区|220103","朝阳区|220104","二道区|220105","绿园区|220106","郊区|220111","双阳区|220112","市区|220120","榆树县|220121","农安县|220122","九台县|220123","德惠县|220124","双阳县|220125","九台市|220181","榆树市|220182","德惠市|220183"});
        map.put("0_6_1", new String[]{"市辖区|220201","昌邑区|220202","龙潭区|220203","船营区|220204","丰满区|220211","市区|220220","永吉县|220221","舒兰县|220222","磐石县|220223","蛟河县|220224","桦甸县|220225","蛟河市|220281","桦甸市|220282","舒兰市|220283","磐石市|220284"});
        map.put("0_6_2", new String[]{"市辖区|220301","铁西区|220302","铁东区|220303","公主岭市|220319","怀德县|220321","梨树县|220322","伊通满族自治县|220323","双辽县|220324","公主岭市|220381","双辽市|220382"});
        map.put("0_6_3", new String[]{"市辖区|220401","龙山区|220402","西安区|220403","东丰县|220421","东辽县|220422"});
        map.put("0_6_4", new String[]{"市辖区|220501","东昌区|220502","二道江区|220503","梅河口市|220519","通化县|220521","集安县|220522","辉南县|220523","柳河县|220524","梅河口市|220581","集安市|220582"});
        map.put("0_6_5", new String[]{"市辖区|220601","八道江区|220602","三岔子区|220603","临江区|220604","抚松县|220621","靖宇县|220622","长白朝鲜族自治县|220623","江源县|220625","临江市|220681"});
        map.put("0_6_6", new String[]{"市辖区|220701","宁江区|220702","前郭尔罗斯蒙古族自治县|220721","长岭县|220722","乾安县|220723","扶余县|220724"});
        map.put("0_6_7", new String[]{"市辖区|220801","洮北区|220802","镇赉县|220821","通榆县|220822","洮南市|220881","大安市|220882"});
        map.put("0_6_8", new String[]{"白城市|222301","洮南市|222302","扶余市|222303","大安市|222304","扶余县|222321","洮安县|222322","长岭县|222323","前郭尔罗斯蒙古族自治县|222324","大安县|222325","镇赉县|222326","通榆县|222327","乾安县|222328"});
        map.put("0_6_9", new String[]{"延吉市|222401","图们市|222402","敦化市|222403","珲春市|222404","龙井市|222405","和龙市|222406","龙井县|222421","敦化县|222422","和龙县|222423","汪清县|222424","珲春县|222425","安图县|222426"});
        map.put("0_6", new String[]{"长春市|220100","吉林市|220200","四平市|220300","辽源市|220400","通化市|220500","白山市|220600","松原市|220700","白城市|220800","白城地区|222300","延边朝鲜族自治州|222400","四平市|222101","辽源市|222102","怀德县|222121","梨树县|222122","伊通满族自治县|222123","东丰县|222124","双辽县|222125","通化市|222201","浑江市|222202","海龙县|222221","通化县|222222","柳河县|222223","辉南县|222224","集安县|222225","抚松县|222226","靖宇县|222227","长白朝鲜族自治县|222228","公主岭市|229001","梅河口市|229002","集安市|229003","桦甸市|229004","九台市|229005"});
        map.put("0_7_0", new String[]{"市辖区|230101","道里区|230102","南岗区|230103","道外区|230104","太平区|230105","香坊区|230106","动力区|230107","平房区|230108","松北区|230109","香坊区|230110","呼兰区|230111","阿城区|230112","阿城市|230119","呼兰县|230121","阿城县|230122","依兰县|230123","方正县|230124","宾县|230125","巴彦县|230126","木兰县|230127","通河县|230128","延寿县|230129","阿城市|230181","双城市|230182","尚志市|230183","五常市|230184"});
        map.put("0_7_1", new String[]{"市辖区|230201","龙沙区|230202","建华区|230203","铁锋区|230204","昂昂溪区|230205","富拉尔基区|230206","碾子山区|230207","梅里斯达斡尔族区|230208","龙江县|230221","讷河县|230222","依安县|230223","泰来县|230224","甘南县|230225","杜尔伯特蒙古族自治县|230226","富裕县|230227","林甸县|230228","克山县|230229","克东县|230230","拜泉县|230231","讷河市|230281"});
        map.put("0_7_2", new String[]{"市辖区|230301","鸡冠区|230302","恒山区|230303","滴道区|230304","梨树区|230305","城子河区|230306","麻山区|230307","鸡东县|230321","虎林市|230381","密山市|230382"});
        map.put("0_7_3", new String[]{"市辖区|230401","向阳区|230402","工农区|230403","南山区|230404","兴安区|230405","东山区|230406","兴山区|230407","萝北县|230421","绥滨县|230422"});
        map.put("0_7_4", new String[]{"市辖区|230501","尖山区|230502","岭东区|230503","岭西区|230504","四方台区|230505","宝山区|230506","集贤县|230521","友谊县|230522","宝清县|230523","饶河县|230524"});
        map.put("0_7_5", new String[]{"市辖区|230601","萨尔图区|230602","龙凤区|230603","让胡路区|230604","红岗区|230605","大同区|230606","肇州县|230621","肇源县|230622","林甸县|230623","杜尔伯特蒙古族自治县|230624"});
        map.put("0_7_6", new String[]{"市辖区|230701","伊春区|230702","南岔区|230703","友好区|230704","西林区|230705","翠峦区|230706","新青区|230707","美溪区|230708","金山屯区|230709","五营区|230710","乌马河区|230711","汤旺河区|230712","带岭区|230713","乌伊岭区|230714","红星区|230715","上甘岭区|230716","铁力县|230721","嘉荫县|230722","铁力市|230781"});
        map.put("0_7_7", new String[]{"市辖区|230801","永红区|230802","向阳区|230803","前进区|230804","东风区|230805","郊区|230811","富锦县|230821","桦南县|230822","依兰县|230823","集贤县|230825","桦川县|230826","宝清县|230827","汤原县|230828","绥滨县|230829","萝北县|230830","同江县|230831","饶河县|230832","抚远县|230833","友谊县|230834","同江市|230881","富锦市|230882"});
        map.put("0_7_8", new String[]{"市辖区|230901","新兴区|230902","桃山区|230903","茄子河区|230904","勃利县|230921"});
        map.put("0_7_9", new String[]{"市辖区|231001","东安区|231002","阳明区|231003","爱民区|231004","西安区|231005","郊区|231011","绥芬河市|231020","宁安县|231021","海林县|231022","穆棱县|231023","东宁县|231024","林口县|231025","密山县|231026","虎林县|231027","绥芬河市|231081","密山市|231082","海林市|231083","宁安市|231084","穆棱市|231085"});
        map.put("0_7_10", new String[]{"市辖区|231101","爱辉区|231102","嫩江县|231121","逊克县|231123","孙吴县|231124","北安市|231181","五大连池市|231182"});
        map.put("0_7_11", new String[]{"市辖区|231201","北林区|231202","望奎县|231221","兰西县|231222","青冈县|231223","庆安县|231224","明水县|231225","绥棱县|231226","安达市|231281","肇东市|231282","海伦市|231283"});
        map.put("0_7_12", new String[]{"双城市|232101","尚志市|232102","五常市|232103","阿城市|232121","宾县|232122","呼兰县|232123","双城市|232124","五常市|232125","巴彦县|232126","木兰县|232127","通河县|232128","尚志市|232129","方正县|232130","延寿县|232131"});
        map.put("0_7_13", new String[]{"绥化市|232301","安达市|232302","肇东市|232303","海伦市|232304","海伦县|232321","肇东县|232322","绥化县|232323","望奎县|232324","兰西县|232325","青冈县|232326","安达县|232327","肇源县|232328","肇州县|232329","庆安县|232330","明水县|232331","绥棱县|232332"});
        map.put("0_7_14", new String[]{"佳木斯市|232401","富锦县|232421","桦南县|232422","依兰县|232423","勃利县|232424","集贤县|232425","桦川县|232426","宝清县|232427","汤原县|232428","绥滨县|232429","萝北县|232430","同江县|232431","饶河县|232432","抚远县|232433"});
        map.put("0_7_15", new String[]{"牡丹江市|232501","绥芬河市|232502","宁安县|232521","海林县|232522","穆棱县|232523","东宁县|232524","林口县|232525","鸡东县|232526","密山县|232527","虎林县|232528"});
        map.put("0_7_16", new String[]{"黑河市|232601","北安市|232602","五大连池市|232603","北安县|232621","嫩江县|232622","德都县|232623","逊克县|232625","孙吴县|232626"});
        map.put("0_7_17", new String[]{"加格达奇区|232701","呼玛县|232721","塔河县|232722","漠河县|232723","漠河县|232724"});
        map.put("0_7", new String[]{"哈尔滨市|230100","齐齐哈尔市|230200","鸡西市|230300","鹤岗市|230400","双鸭山市|230500","大庆市|230600","伊春市|230700","佳木斯市|230800","七台河市|230900","牡丹江市|231000","黑河市|231100","绥化市|231200","松花江地区|232100","绥化地区|232300","佳木斯地区|232400","牡丹江地区|232500","黑河地区|232600","大兴安岭地区|232700","绥芬河市|239001","阿城市|239002","同江市|239003","富锦市|239004","铁力市|239005","密山市|239006"});
        map.put("0_8", new String[]{"黄浦区|310101","南市区|310102","卢湾区|310103","徐汇区|310104","长宁区|310105","静安区|310106","普陀区|310107","闸北区|310108","虹口区|310109","杨浦区|310110","吴凇区|310111","闵行区|310112","宝山区|310113","嘉定区|310114","浦东新区|310115","金山区|310116","松江区|310117","青浦区|310118","南汇区|310119","奉贤区|310120","上海县|310221","嘉定县|310222","宝山县|310223","川沙县|310224","南汇县|310225","奉贤县|310226","松江县|310227","金山县|310228","青浦县|310229","崇明县|310230"});
        map.put("0_9_0", new String[]{"市辖区|320101","玄武区|320102","白下区|320103","秦淮区|320104","建邺区|320105","鼓楼区|320106","下关区|320107","浦口区|320111","大厂区|320112","栖霞区|320113","雨花台区|320114","江宁区|320115","六合区|320116","市区|320120","江宁县|320121","江浦县|320122","六合县|320123","溧水县|320124","高淳县|320125","江都县|320126"});
        map.put("0_9_1", new String[]{"市辖区|320201","崇安区|320202","南长区|320203","北塘区|320204","锡山区|320205","惠山区|320206","郊区|320211","马山区|320212","江阴县|320219","江阴县|320221","无锡县|320222","宜兴县|320223","江阴市|320281","宜兴市|320282","锡山市|320283"});
        map.put("0_9_2", new String[]{"市辖区|320301","鼓楼区|320302","云龙区|320303","九里区|320304","贾汪区|320305","泉山区|320311","丰县|320321","沛县|320322","铜山县|320323","睢宁县|320324","邳县|320325","新沂县|320326","新沂市|320381","邳州市|320382"});
        map.put("0_9_3", new String[]{"市辖区|320401","天宁区|320402","钟楼区|320404","戚墅堰区|320405","郊区|320411","武进区|320412","武进市|320419","武进县|320421","金坛县|320422","溧阳县|320423","溧阳市|320481","金坛市|320482","武进市|320483"});
        map.put("0_9_4", new String[]{"市辖区|320501","沧浪区|320502","平江区|320503","金阊区|320504","虎丘区|320505","吴中区|320506","相城区|320507","郊区|320511","常熟市|320520","沙洲县|320521","太仓县|320522","昆山县|320523","吴县|320524","吴江县|320525","常熟市|320581","张家港市|320582","昆山市|320583","吴江市|320584","太仓市|320585","吴县市|320586"});
        map.put("0_9_5", new String[]{"市辖区|320601","崇川区|320602","港闸区|320611","海安县|320621","如皋县|320622","如东县|320623","南通县|320624","海门县|320625","启东县|320626","启东市|320681","如皋市|320682","通州市|320683","海门市|320684"});
        map.put("0_9_6", new String[]{"市辖区|320701","连云区|320703","云台区|320704","新浦区|320705","海州区|320706","赣榆县|320721","东海县|320722","灌云县|320723","灌南县|320724"});
        map.put("0_9_7", new String[]{"市辖区|320801","清河区|320802","楚州区|320803","淮阴区|320804","清浦区|320811","宿迁市|320819","淮阴县|320821","灌南县|320822","沭阳县|320823","宿迁县|320824","泗阳县|320825","涟水县|320826","泗洪县|320827","淮安县|320828","洪泽县|320829","盱眙县|320830","金湖县|320831","宿迁市|320881","淮安市|320882"});
        map.put("0_9_8", new String[]{"市辖区|320901","城区|320902","盐都区|320903","郊区|320911","东台市|320919","响水县|320921","滨海县|320922","阜宁县|320923","射阳县|320924","建湖县|320925","大丰县|320926","东台县|320927","盐都县|320928","东台市|320981","大丰市|320982"});
        map.put("0_9_9", new String[]{"市辖区|321001","广陵区|321002","邗江区|321003","郊区|321011","仪征市|321019","泰州市|321020","兴化县|321021","高邮县|321022","宝应县|321023","靖江县|321024","泰兴县|321025","江都县|321026","邗江县|321027","泰县|321028","仪征县|321029","仪征市|321081","泰州市|321082","兴化市|321083","高邮市|321084","泰兴市|321085","靖江市|321086","江都市|321087","江都市|321088"});
        map.put("0_9_10", new String[]{"市辖区|321101","京口区|321102","润州区|321111","丹徒区|321112","丹阳市|321119","丹徒县|321121","丹阳县|321122","句容县|321123","扬中县|321124","丹阳市|321181","扬中市|321182","句容市|321183"});
        map.put("0_9_11", new String[]{"市辖区|321201","海陵区|321202","高港区|321203","兴化市|321281","靖江市|321282","泰兴市|321283","姜堰市|321284"});
        map.put("0_9_12", new String[]{"市辖区|321301","宿城区|321302","宿豫区|321311","宿豫县|321321","沭阳县|321322","泗阳县|321323","泗洪县|321324"});
        map.put("0_9", new String[]{"南京市|320100","无锡市|320200","徐州市|320300","常州市|320400","苏州市|320500","南通市|320600","连云港市|320700","淮安市|320800","盐城市|320900","扬州市|321000","镇江市|321100","泰州市|321200","宿迁市|321300"});
        map.put("0_10_0", new String[]{"市辖区|330101","上城区|330102","下城区|330103","江干区|330104","拱墅区|330105","西湖区|330106","滨江区|330107","滨江区|330108","萧山区|330109","余杭区|330110","市区|330120","萧山县|330121","桐庐县|330122","富阳县|330123","临安县|330124","余杭县|330125","建德县|330126","淳安县|330127","萧山市|330181","建德市|330182","富阳市|330183","余杭市|330184","临安市|330185"});
        map.put("0_10_1", new String[]{"椒江区|331002","黄岩区|331003","路桥区|331004","玉环县|331021","三门县|331022","天台县|331023","仙居县|331024","温岭市|331081","临海市|331082","市辖区|331001"});
        map.put("0_10_2", new String[]{"市辖区|331101","莲都区|331102","青田县|331121","缙云县|331122","遂昌县|331123","松阳县|331124","云和县|331125","庆元县|331126","景宁畲族自治县|331127","龙泉市|331181"});
        map.put("0_10_3", new String[]{"丽水市|332501","龙泉市|332502","丽水县|332521","青田县|332522","云和县|332523","龙泉县|332524","庆元县|332525","缙云县|332526","遂昌县|332527","松阳县|332528","景宁畲族自治县|332529"});
        map.put("0_10_4", new String[]{"椒江市|332601","临海市|332602","黄岩市|332603","临海县|332621","黄岩县|332622","温岭县|332623","仙居县|332624","天台县|332625","三门县|332626","玉环县|332627"});
        map.put("0_10_5", new String[]{"定海县|332721","普陀县|332722","岱山县|332723","嵊泗县|332724"});
        map.put("0_10_6", new String[]{"市辖区|330201","镇明区|330202","海曙区|330203","江东区|330204","江北区|330205","北仑区|330206","鄞州区|330207","镇海区|330211","鄞州区|330212","余姚市|330219","镇海县|330221","慈溪县|330222","余姚县|330223","奉化县|330224","象山县|330225","宁海县|330226","鄞县|330227","余姚市|330281","慈溪市|330282","奉化市|330283"});
        map.put("0_10_7", new String[]{"市辖区|330301","鹿城区|330302","龙湾区|330303","瓯海区|330304","瓯海县|330321","洞头县|330322","乐清县|330323","永嘉县|330324","瑞安县|330325","平阳县|330326","苍南县|330327","文成县|330328","泰顺县|330329","瑞安市|330381","乐清市|330382"});
        map.put("0_10_8", new String[]{"市辖区|330401","秀城区|330402","郊区|330411","海宁市|330419","嘉善县|330421","平湖县|330422","海宁县|330423","海盐县|330424","桐乡县|330425","海宁市|330481","平湖市|330482","桐乡市|330483"});
        map.put("0_10_9", new String[]{"市辖区|330501","吴兴区|330502","南浔区|330503","郊区|330511","德清县|330521","长兴县|330522","安吉县|330523"});
        map.put("0_10_10", new String[]{"市辖区|330601","越城区|330602","绍兴县|330621","上虞县|330622","嵊县|330623","新昌县|330624","诸暨县|330625","诸暨市|330681","上虞市|330682","嵊州市|330683"});
        map.put("0_10_11", new String[]{"市辖区|330701","婺城区|330702","金东区|330703","兰溪市|330719","金华县|330721","永康县|330722","武义县|330723","东阳县|330724","义乌县|330725","浦江县|330726","磐安县|330727","兰溪市|330781","义乌市|330782","东阳市|330783","永康市|330784"});
        map.put("0_10_12", new String[]{"市辖区|330801","柯城区|330802","衢江区|330803","衢县|330821","常山县|330822","江山县|330823","开化县|330824","龙游县|330825","江山市|330881"});
        map.put("0_10_13", new String[]{"市辖区|330901","定海区|330902","普陀区|330903","岱山县|330921","嵊泗县|330922"});
        map.put("0_10", new String[]{"杭州市|330100","台州市|331000","丽水市|331100","丽水地区|332500","台州地区|332600","舟山地区|332700","宁波市|330200","温州市|330300","嘉兴市|330400","湖州市|330500","绍兴市|330600","金华市|330700","衢州市|330800","舟山市|330900","余姚市|339001","海宁市|339002","兰溪市|339003","瑞安市|339004","萧山市|339005","江山市|339006","义乌市|339007","东阳市|339008","慈溪市|339009","奉化市|339010","诸暨市|339011"});
        map.put("0_11_0", new String[]{"临泉县|341221","太和县|341222","涡阳县|341223","蒙城县|341224","阜南县|341225","颍上县|341226","利辛县|341227","亳州市|341281","界首市|341282","市辖区|341201","颍州区|341202","颍东区|341203","颍泉区|341204"});
        map.put("0_11_1", new String[]{"市辖区|341301","墉桥区|341302","砀山县|341321","萧县|341322","灵璧县|341323","泗县|341324"});
        map.put("0_11_2", new String[]{"市辖区|341401","居巢区|341402","庐江县|341421","无为县|341422","含山县|341423","和县|341424"});
        map.put("0_11_3", new String[]{"市辖区|341501","金安区|341502","裕安区|341503","寿县|341521","霍邱县|341522","舒城县|341523","金寨县|341524","霍山县|341525"});
        map.put("0_11_4", new String[]{"市辖区|341601","谯城区|341602","涡阳县|341621","蒙城县|341622","利辛县|341623"});
        map.put("0_11_5", new String[]{"市辖区|341701","贵池区|341702","东至县|341721","石台县|341722","青阳县|341723"});
        map.put("0_11_6", new String[]{"市辖区|341801","宣州区|341802","郎溪县|341821","广德县|341822","泾县|341823","绩溪县|341824","旌德县|341825","宁国市|341881"});
        map.put("0_11_7", new String[]{"阜阳市|342101","阜阳县|342121","临泉县|342122","太和县|342123","涡阳县|342124","蒙城县|342125","亳县|342126","阜南县|342127","颍上县|342128","界首县|342129","利辛县|342130"});
        map.put("0_11_8", new String[]{"宿州市|342201","砀山县|342221","萧县|342222","宿县|342223","灵璧县|342224","泗县|342225","怀远县|342226","五河县|342227","固镇县|342228"});
        map.put("0_11_9", new String[]{"滁州市|342301","天长县|342321","来安县|342322","滁县|342323","全椒县|342324","定远县|342325","凤阳县|342326","嘉山县|342327"});
        map.put("0_11_10", new String[]{"六安市|342401","六安县|342421","寿县|342422","霍邱县|342423","肥西县|342424","舒城县|342425","金寨县|342426","霍山县|342427"});
        map.put("0_11_11", new String[]{"宣州市|342501","宁国市|342502","宣州县|342521","郎溪县|342522","广德县|342523","宁国县|342524","当涂县|342525","繁昌县|342526","南陵县|342527","青阳县|342528","泾县|342529","旌德县|342530","绩溪县|342531"});
        map.put("0_11_12", new String[]{"巢湖市|342601","肥东县|342621","庐江县|342622","无为县|342623","巢县|342624","含山县|342625","和县|342626"});
        map.put("0_11_13", new String[]{"屯溪市|342701","绩溪县|342721","旌德县|342722","歙县|342723","休宁县|342724","黟县|342725","祁门县|342726","太平县|342727","石台县|342728"});
        map.put("0_11_14", new String[]{"怀宁县|342821","桐城县|342822","枞阳县|342823","潜山县|342824","太湖县|342825","宿松县|342826","望江县|342827","岳西县|342828","东至县|342829","贵池县|342830"});
        map.put("0_11_15", new String[]{"贵池市|342901","东至县|342921","石台县|342922","青阳县|342923"});
        map.put("0_11_16", new String[]{"市辖区|340101","瑶海区|340102","庐阳区|340103","蜀山区|340104","包河区|340111","长丰县|340121","肥西县|340122","肥东县|340123"});
        map.put("0_11_17", new String[]{"市辖区|340201","镜湖区|340202","弋江区|340203","新芜区|340204","裕溪口区|340205","四褐山区|340206","鸠江区|340207","三山区|340208","郊区|340211","市区|340220","芜湖县|340221","繁昌县|340222","南陵县|340223","青阳县|340224"});
        map.put("0_11_18", new String[]{"市辖区|340301","龙子湖区|340302","蚌山区|340303","禹会区|340304","淮上区|340311","怀远县|340321","五河县|340322","固镇县|340323"});
        map.put("0_11_19", new String[]{"市辖区|340401","大通区|340402","田家庵区|340403","谢家集区|340404","八公山区|340405","潘集区|340406","凤台县|340421"});
        map.put("0_11_20", new String[]{"市辖区|340501","金家庄区|340502","花山区|340503","雨山区|340504","向山区|340505","当涂县|340521"});
        map.put("0_11_21", new String[]{"市辖区|340601","杜集区|340602","相山区|340603","烈山区|340604","濉溪县|340621"});
        map.put("0_11_22", new String[]{"市辖区|340701","铜官山区|340702","狮子山区|340703","郊区|340711","铜陵县|340721"});
        map.put("0_11_23", new String[]{"市辖区|340801","迎江区|340802","大观区|340803","郊区|340811","桐城县|340821","怀宁县|340822","枞阳县|340823","潜山县|340824","太湖县|340825","宿松县|340826","望江县|340827","岳西县|340828","桐城市|340881"});
        map.put("0_11_24", new String[]{"市辖区|341001","屯溪区|341002","黄山区|341003","徽州区|341004","歙县|341021","休宁县|341022","黟县|341023","祁门县|341024"});
        map.put("0_11_25", new String[]{"市辖区|341101","琅琊区|341102","南谯区|341103","天长县|341121","来安县|341122","全椒县|341124","定远县|341125","凤阳县|341126","嘉山县|341127","天长市|341181","明光市|341182"});
        map.put("0_11", new String[]{"阜阳市|341200","宿州市|341300","巢湖市|341400","六安市|341500","亳州市|341600","池州市|341700","宣城市|341800","阜阳地区|342100","宿县地区|342200","滁县地区|342300","六安地区|342400","宣城地区|342500","巢湖地区|342600","徽州地区|342700","安庆地区|342800","池州地区|342900","合肥市|340100","芜湖市|340200","蚌埠市|340300","淮南市|340400","马鞍山市|340500","淮北市|340600","铜陵市|340700","安庆市|340800","黄山市|341000","滁州市|341100"});
        map.put("0_12_0", new String[]{"市辖区|350901","蕉城区|350902","霞浦县|350921","古田县|350922","屏南县|350923","寿宁县|350924","周宁县|350925","柘荣县|350926","福安市|350981","福鼎市|350982"});
        map.put("0_12_1", new String[]{"南平市|352101","邵武市|352102","武夷山市|352103","建瓯市|352104","顺昌县|352121","建阳县|352122","建瓯县|352123","浦城县|352124","邵武县|352125","崇安县|352126","光泽县|352127","松溪县|352128","政和县|352129"});
        map.put("0_12_2", new String[]{"宁德市|352201","福安市|352202","福鼎市|352203","宁德县|352221","连江县|352222","罗源县|352223","福鼎县|352224","霞浦县|352225","福安县|352226","古田县|352227","屏南县|352228","寿宁县|352229","周宁县|352230","柘荣县|352231"});
        map.put("0_12_3", new String[]{"龙岩市|352601","漳平市|352602","长汀县|352622","永定县|352623","上杭县|352624","武平县|352625","漳平县|352626","连城县|352627"});
        map.put("0_12_4", new String[]{"三明市|352701","明溪县|352721","永安县|352722","清流县|352723","宁化县|352724","大田县|352725","尤溪县|352726","沙县|352727","将乐县|352728","泰宁县|352729","建宁县|352730"});
        map.put("0_12_5", new String[]{"市辖区|350101","鼓楼区|350102","台江区|350103","仓山区|350104","马尾区|350105","晋安区|350111","市区|350120","闽侯县|350121","连江县|350122","罗源县|350123","闽清县|350124","永泰县|350125","长乐县|350126","福清县|350127","平潭县|350128","福清市|350181","长乐市|350182"});
        map.put("0_12_6", new String[]{"市辖区|350201","鼓浪屿区|350202","思明区|350203","开元区|350204","海沧区|350205","湖里区|350206","集美区|350211","同安区|350212","翔安区|350213"});
        map.put("0_12_7", new String[]{"市辖区|350301","城厢区|350302","涵江区|350303","荔城区|350304","秀屿区|350305","莆田县|350321","仙游县|350322"});
        map.put("0_12_8", new String[]{"市辖区|350401","梅列区|350402","三元区|350403","永安市|350404","永安市|350420","明溪县|350421","永安县|350422","清流县|350423","宁化县|350424","大田县|350425","尤溪县|350426","沙县|350427","将乐县|350428","泰宁县|350429","建宁县|350430","永安市|350481"});
        map.put("0_12_9", new String[]{"市辖区|350501","鲤城区|350502","丰泽区|350503","洛江区|350504","泉港区|350505","惠安县|350521","晋江县|350522","南安县|350523","安溪县|350524","永春县|350525","德化县|350526","金门县|350527","石狮市|350581","晋江市|350582","南安市|350583"});
        map.put("0_12_10", new String[]{"市辖区|350601","芗城区|350602","龙文区|350603","龙海县|350621","云霄县|350622","漳浦县|350623","诏安县|350624","长泰县|350625","东山县|350626","南靖县|350627","平和县|350628","华安县|350629","龙海市|350681"});
        map.put("0_12_11", new String[]{"市辖区|350701","延平区|350702","顺昌县|350721","浦城县|350722","光泽县|350723","松溪县|350724","政和县|350725","邵武市|350781","武夷山市|350782","建瓯市|350783","建阳市|350784"});
        map.put("0_12_12", new String[]{"市辖区|350801","新罗区|350802","长汀县|350821","永定县|350822","上杭县|350823","武平县|350824","连城县|350825","漳平市|350881"});
        map.put("0_12", new String[]{"宁德市|350900","南平地区|352100","宁德地区|352200","龙岩地区|352600","三明市|352700","福州市|350100","厦门市|350200","莆田市|350300","三明市|350400","泉州市|350500","漳州市|350600","南平市|350700","龙岩市|350800","永安市|359001","石狮市|359002"});
        map.put("0_13_0", new String[]{"市辖区|360101","东湖区|360102","西湖区|360103","青云谱区|360104","湾里区|360105","郊区|360111","南昌县|360121","新建县|360122","安义县|360123","进贤县|360124"});
        map.put("0_13_1", new String[]{"市辖区|360201","昌江区|360202","珠山区|360203","鹅湖区|360211","蛟潭区|360212","乐平县|360221","浮梁县|360222","乐平市|360281"});
        map.put("0_13_2", new String[]{"鄱阳县|361128","万年县|361129","婺源县|361130","德兴市|361181","市辖区|361101","信州区|361102","上饶县|361121","广丰县|361122","玉山县|361123","铅山县|361124","横峰县|361125","弋阳县|361126","余干县|361127"});
        map.put("0_13_3", new String[]{"赣州市|362101","瑞金市|362102","南康市|362103","赣县|362121","南康市|362122","信丰县|362123","大余县|362124","上犹县|362125","崇义县|362126","安远县|362127","龙南县|362128","定南县|362129","全南县|362130","宁都县|362131","于都县|362132","兴国县|362133","瑞金市|362134","会昌县|362135","寻乌县|362136","石城县|362137","广昌县|362138"});
        map.put("0_13_4", new String[]{"宜春市|362201","丰城市|362202","樟树市|362203","高安市|362204","丰城县|362221","高安县|362222","清江县|362223","新余县|362224","宜春县|362225","奉新县|362226","万载县|362227","上高县|362228","宜丰县|362229","分宜县|362230","安义县|362231","靖安县|362232","铜鼓县|362233"});
        map.put("0_13_5", new String[]{"上饶市|362301","德兴市|362302","上饶县|362321","广丰县|362322","玉山县|362323","铅山县|362324","横峰县|362325","弋阳县|362326","贵溪县|362327","余江县|362328","余干县|362329","波阳县|362330","万年县|362331","乐平县|362332","德兴县|362333","婺源县|362334"});
        map.put("0_13_6", new String[]{"市辖区|360301","安源区|360302","上栗区|360311","芦溪区|360312","湘东区|360313","莲花县|360321","上栗县|360322","芦溪县|360323"});
        map.put("0_13_7", new String[]{"市辖区|360401","庐山区|360402","浔阳区|360403","九江县|360421","瑞昌县|360422","武宁县|360423","修水县|360424","永修县|360425","德安县|360426","星子县|360427","都昌县|360428","湖口县|360429","彭泽县|360430","瑞昌市|360481"});
        map.put("0_13_8", new String[]{"市辖区|360501","渝水区|360502","分宜县|360521"});
        map.put("0_13_9", new String[]{"市辖区|360601","月湖区|360602","贵溪县|360621","余江县|360622","贵溪市|360681"});
        map.put("0_13_10", new String[]{"市辖区|360701","章贡区|360702","赣县|360721","信丰县|360722","大余县|360723","上犹县|360724","崇义县|360725","安远县|360726","龙南县|360727","定南县|360728","全南县|360729","宁都县|360730","于都县|360731","兴国县|360732","会昌县|360733","寻乌县|360734","石城县|360735","瑞金市|360781","南康市|360782"});
        map.put("0_13_11", new String[]{"市辖区|360801","吉州区|360802","青原区|360803","吉安县|360821","吉水县|360822","峡江县|360823","新干县|360824","永丰县|360825","泰和县|360826","遂川县|360827","万安县|360828","安福县|360829","永新县|360830","井冈山市|360881"});
        map.put("0_13_12", new String[]{"市辖区|360901","袁州区|360902","奉新县|360921","万载县|360922","上高县|360923","宜丰县|360924","靖安县|360925","铜鼓县|360926","丰城市|360981","樟树市|360982","高安市|360983"});
        map.put("0_13_13", new String[]{"市辖区|361001","临川区|361002","南城县|361021","黎川县|361022","南丰县|361023","崇仁县|361024","乐安县|361025","宜黄县|361026","金溪县|361027","资溪县|361028","东乡县|361029","广昌县|361030"});
        map.put("0_13_14", new String[]{"吉安市|362401","井冈山市|362402","吉安县|362421","吉水县|362422","峡江县|362423","新干县|362424","永丰县|362425","泰和县|362426","遂川县|362427","万安县|362428","安福县|362429","永新县|362430","莲花县|362431","宁冈县|362432","井岗山县|362433"});
        map.put("0_13_15", new String[]{"临川市|362501","临川市|362502","临川县|362521","南城县|362522","黎川县|362523","南丰县|362524","崇仁县|362525","乐安县|362526","宜黄县|362527","金溪县|362528","资溪县|362529","进贤县|362530","东乡县|362531","广昌县|362532"});
        map.put("0_13_16", new String[]{"九江县|362621","瑞昌县|362622","武宁县|362623","修水县|362624","永修县|362625","德安县|362626","星子县|362627","都昌县|362628","湖口县|362629","彭泽县|362630"});
        map.put("0_13", new String[]{"南昌市|360100","景德镇市|360200","上饶市|361100","赣州地区|362100","宜春地区|362200","上饶地区|362300","萍乡市|360300","九江市|360400","新余市|360500","鹰潭市|360600","赣州市|360700","吉安市|360800","宜春市|360900","抚州市|361000","吉安地区|362400","抚州地区|362500","九江地区|362600"});
        map.put("0_14_0", new String[]{"崂山区|370212","李沧区|370213","城阳区|370214","市区|370220","崂山县|370221","即墨县|370222","胶南县|370223","胶县|370224","莱西县|370225","平度县|370226","胶州市|370281","即墨市|370282","平度市|370283","胶南市|370284","莱西市|370285","市辖区|370201","市南区|370202","市北区|370203","台东区|370204","四方区|370205","沧口区|370206","黄岛区|370211"});
        map.put("0_14_1", new String[]{"市辖区|370301","淄川区|370302","张店区|370303","博山区|370304","临淄区|370305","周村区|370306","桓台县|370321","高青县|370322","沂源县|370323"});
        map.put("0_14_2", new String[]{"市辖区|370401","市中区|370402","薛城区|370403","峄城区|370404","台儿庄区|370405","山亭区|370406","市区|370420","滕县|370421","滕州市|370481"});
        map.put("0_14_3", new String[]{"市辖区|370501","东营区|370502","河口区|370503","垦利县|370521","利津县|370522","广饶县|370523"});
        map.put("0_14_4", new String[]{"市辖区|370601","芝罘区|370602","福山区|370611","牟平区|370612","莱山区|370613","龙口市|370619","威海市|370620","蓬莱县|370622","黄县|370623","招远县|370624","掖县|370625","莱阳县|370627","栖霞县|370628","海阳县|370629","牟平县|370631","文登县|370632","荣城县|370633","长岛县|370634","龙口市|370681","莱阳市|370682","莱州市|370683","蓬莱市|370684","招远市|370685","栖霞市|370686","海阳市|370687"});
        map.put("0_14_5", new String[]{"市辖区|370701","潍城区|370702","寒亭区|370703","坊子区|370704","奎文区|370705","青州市|370719","益都县|370721","安丘县|370722","寿光县|370723","临朐县|370724","昌乐县|370725","昌邑县|370726","高密县|370727","诸城县|370728","五莲县|370729","青州市|370781","诸城市|370782","寿光市|370783","安丘市|370784","高密市|370785","昌邑市|370786"});
        map.put("0_14_6", new String[]{"市辖区|370801","市中区|370802","任城区|370811","曲阜市|370819","兖州县|370822","曲阜县|370823","邹县|370825","微山县|370826","鱼台县|370827","金乡县|370828","嘉祥县|370829","汶上县|370830","泗水县|370831","梁山县|370832","曲阜市|370881","兖州市|370882","邹城市|370883"});
        map.put("0_14_7", new String[]{"市辖区|370901","泰山区|370902","岱岳区|370903","郊区|370911","莱芜市|370919","新泰市|370920","宁阳县|370921","肥城县|370922","东平县|370923","莱芜市|370981","新泰市|370982","肥城市|370983"});
        map.put("0_14_8", new String[]{"市辖区|371001","环翠区|371002","乳山县|371021","文登市|371081","荣成市|371082","乳山市|371083"});
        map.put("0_14_9", new String[]{"市辖区|371101","东港区|371102","岚山区|371103","五莲县|371121","莒县|371122"});
        map.put("0_14_10", new String[]{"市辖区|371201","莱城区|371202","钢城区|371203"});
        map.put("0_14_11", new String[]{"市辖区|371301","兰山区|371302","罗庄区|371311","河东区|371312","沂南县|371321","郯城县|371322","沂水县|371323","苍山县|371324","费县|371325","平邑县|371326","莒南县|371327","蒙阴县|371328","临沭县|371329"});
        map.put("0_14_12", new String[]{"市辖区|371401","德城区|371402","陵县|371421","宁津县|371422","庆云县|371423","临邑县|371424","齐河县|371425","平原县|371426","夏津县|371427","武城县|371428","乐陵市|371481","禹城市|371482"});
        map.put("0_14_13", new String[]{"市辖区|371501","东昌府区|371502","阳谷县|371521","莘县|371522","茌平县|371523","东阿县|371524","冠县|371525","高唐县|371526","临清市|371581"});
        map.put("0_14_14", new String[]{"市辖区|371601","滨城区|371602","惠民县|371621","阳信县|371622","无棣县|371623","沾化县|371624","博兴县|371625","邹平县|371626"});
        map.put("0_14_15", new String[]{"市辖区|370101","历下区|370102","市中区|370103","槐荫区|370104","天桥区|370105","郊区|370111","历城区|370112","长清区|370113","市区|370120","历城县|370121","章丘县|370122","长清县|370123","平阴县|370124","济阳县|370125","商河县|370126","章丘市|370181"});
        map.put("0_14_16", new String[]{"市辖区|371701","牡丹区|371702","曹县|371721","单县|371722","成武县|371723","巨野县|371724","郓城县|371725","鄄城县|371726","定陶县|371727","东明县|371728"});
        map.put("0_14_17", new String[]{"烟台市|372101","威海市|372102","福山县|372121","蓬莱县|372122","招远县|372124","掖县|372125","莱西县|372126","莱阳县|372127","栖霞县|372128","海阳县|372129","乳山县|372130","牟平县|372131","文登县|372132","荣城县|372133","长岛县|372134"});
        map.put("0_14_18", new String[]{"潍坊市|372201","益都县|372221","安丘县|372222","寿光县|372223","临朐县|372224","昌乐县|372225","昌邑县|372226","高密县|372227","诸城县|372228","平度县|372230","潍县|372231"});
        map.put("0_14_19", new String[]{"滨州市|372301","惠民县|372321","滨县|372322","阳信县|372323","无棣县|372324","沾化县|372325","利津县|372326","广饶县|372327","博兴县|372328","桓台县|372329","邹平县|372330","高青县|372331","垦利县|372332"});
        map.put("0_14_20", new String[]{"德州市|372401","乐陵市|372402","禹城市|372403","陵县|372421","平原县|372422","夏津县|372423","武城县|372424","齐河县|372425","禹城县|372426","乐陵县|372427","临邑县|372428","商河县|372429","济阳县|372430","宁津县|372431","庆云县|372432"});
        map.put("0_14_21", new String[]{"聊城市|372501","东昌府区|372502","阳谷县|372521","莘县|372522","茌平县|372523","东阿县|372524","冠县|372525","高唐县|372526","高唐县|372527","临清县|372528","临清市|372581"});
        map.put("0_14_22", new String[]{"泰安市|372601","莱芜市|372602","新泰市|372603","莱芜县|372622","新泰县|372623","宁阳县|372624","肥城县|372625","东平县|372626","平阴县|372627","新汶县|372628","泗水县|372630"});
        map.put("0_14_23", new String[]{"济宁市|372701","兖州县|372722","曲阜县|372723","泗水县|372724","邹县|372725","微山县|372726","鱼台县|372727","金乡县|372728","嘉祥县|372729"});
        map.put("0_14_24", new String[]{"临沂市|372801","日照市|372802","临沂县|372821","郯城县|372822","苍山县|372823","莒南县|372824","日照县|372825","莒县|372826","沂水县|372827","沂源县|372828","蒙阴县|372829","平邑县|372830","费县|372831","沂南县|372832","临沭县|372833"});
        map.put("0_14_25", new String[]{"菏泽市|372901","菏泽县|372921","曹县|372922","定陶县|372923","成武县|372924","单县|372925","巨野县|372926","粱山县|372927","郓城县|372928","鄄城县|372929","东明县|372930"});
        map.put("0_14", new String[]{"青岛市|370200","淄博市|370300","枣庄市|370400","东营市|370500","烟台市|370600","潍坊市|370700","济宁市|370800","泰安市|370900","威海市|371000","日照市|371100","莱芜市|371200","临沂市|371300","德州市|371400","聊城市|371500","滨州市|371600","济南市|370100","菏泽市|371700","烟台地区|372100","潍坊地区|372200","滨州地区|372300","德州地区|372400","聊城市|372500","泰安地区|372600","济宁地区|372700","临沂地区|372800","菏泽地区|372900","青州市|379001","龙口市|379002","曲阜市|379003","莱芜市|379004","新泰市|379005","胶州市|379006","诸城市|379007","莱阳市|379008","莱州市|379009","滕州市|379010","文登市|379011","荣城市|379012"});
        map.put("0_15_0", new String[]{"鹤山区|410602","山城区|410603","淇滨区|410611","浚县|410621","淇县|410622","市辖区|410601"});
        map.put("0_15_1", new String[]{"市辖区|410701","红旗区|410702","新华区|410703","北站区|410704","郊区|410711","新乡县|410721","汲县|410722","辉县|410723","获嘉县|410724","原阳县|410725","延津县|410726","封丘县|410727","长垣县|410728","卫辉市|410781","辉县市|410782"});
        map.put("0_15_2", new String[]{"市辖区|410801","解放区|410802","中站区|410803","马村区|410804","山阳区|410811","修武县|410821","博爱县|410822","武陟县|410823","沁阳县|410824","温县|410825","孟县|410826","济源县|410827","济源市|410881","沁阳市|410882","孟州市|410883"});
        map.put("0_15_3", new String[]{"市辖区|410901","市区|410902","滑县|410921","清丰县|410922","南乐县|410923","内黄县|410924","长垣县|410925","范县|410926","台前县|410927","濮阳县|410928"});
        map.put("0_15_4", new String[]{"市辖区|411001","魏都区|411002","禹县|411021","长葛县|411022","许昌县|411023","鄢陵县|411024","襄城县|411025","禹州市|411081","长葛市|411082"});
        map.put("0_15_5", new String[]{"市辖区|411101","源汇区|411102","郾城区|411103","召陵区|411104","舞阳县|411121","临颍县|411122","郾城县|411123"});
        map.put("0_15_6", new String[]{"市辖区|411201","湖滨区|411202","渑池县|411221","陕县|411222","灵宝县|411223","卢氏县|411224","义马市|411281","灵宝市|411282"});
        map.put("0_15_7", new String[]{"市辖区|411301","宛城区|411302","卧龙区|411303","南召县|411321","方城县|411322","西峡县|411323","镇平县|411324","内乡县|411325","淅川县|411326","社旗县|411327","唐河县|411328","新野县|411329","桐柏县|411330","邓州市|411381"});
        map.put("0_15_8", new String[]{"市辖区|410101","中原区|410102","二七区|410103","管城回族区|410104","金水区|410105","上街区|410106","新密区|410107","邙山区|410108","金海区|410111","郊区|410112","市区|410120","荥阳县|410121","中牟县|410122","新郑县|410123","巩县|410124","登封县|410125","密县|410126","巩义市|410181","荥阳市|410182","新密市|410183","新郑市|410184","登封市|410185"});
        map.put("0_15_9", new String[]{"市辖区|410201","龙亭区|410202","顺河回族区|410203","鼓楼区|410204","禹王台区|410205","金明区|410211","杞县|410221","通许县|410222","尉氏县|410223","开封县|410224","兰考县|410225"});
        map.put("0_15_10", new String[]{"市辖区|410301","老城区|410302","西工区|410303","廛河回族区|410304","涧西区|410305","吉利区|410306","洛龙区|410307","郊区|410311","偃师县|410321","孟津县|410322","新安县|410323","栾川县|410324","嵩县|410325","汝阳县|410326","宜阳县|410327","洛宁县|410328","伊川县|410329","偃师市|410381"});
        map.put("0_15_11", new String[]{"市辖区|410401","新华区|410402","卫东区|410403","石龙区|410404","湛河区|410411","舞钢区|410412","宝丰县|410421","叶县|410422","鲁山县|410423","临汝县|410424","郏县|410425","襄城县|410426","舞钢市|410481","汝州市|410482"});
        map.put("0_15_12", new String[]{"市辖区|410501","文峰区|410502","北关区|410503","铁西区|410504","殷都区|410505","龙安区|410506","郊区|410511","林县|410521","安阳县|410522","汤阴县|410523","淇县|410524","浚县|410525","滑县|410526","内黄县|410527","林州市|410581"});
        map.put("0_15_13", new String[]{"市辖区|411401","梁园区|411402","睢阳区|411403","民权县|411421","睢县|411422","宁陵县|411423","柘城县|411424","虞城县|411425","夏邑县|411426","永城市|411481"});
        map.put("0_15_14", new String[]{"市辖区|411501","师河区|411502","平桥区|411503","罗山县|411521","光山县|411522","新县|411523","商城县|411524","固始县|411525","潢川县|411526","淮滨县|411527","息县|411528"});
        map.put("0_15_15", new String[]{"市辖区|411601","川汇区|411602","扶沟县|411621","西华县|411622","商水县|411623","沈丘县|411624","郸城县|411625","淮阳县|411626","太康县|411627","鹿邑县|411628","项城市|411681"});
        map.put("0_15_16", new String[]{"市辖区|411701","驿城区|411702","西平县|411721","上蔡县|411722","平舆县|411723","正阳县|411724","确山县|411725","泌阳县|411726","汝南县|411727","遂平县|411728","新蔡县|411729"});
        map.put("0_15_17", new String[]{"商丘市|412301","永城市|412302","虞城县|412321","商丘县|412322","民权县|412323","宁陵县|412324","睢县|412325","夏邑县|412326","柘城县|412327","永城县|412328"});
        map.put("0_15_18", new String[]{"杞县|412421","通许县|412422","尉氏县|412423","开封县|412424","中牟县|412425","新郑县|412426","巩县|412427","登封县|412428","密县|412429","兰考县|412430"});
        map.put("0_15_19", new String[]{"三门峡市|412501","义马市|412502","偃师县|412521","孟津县|412522","新安县|412523","渑池县|412524","陕县|412525","灵宝县|412526","伊川县|412527","汝阳县|412528","嵩县|412529","洛宁县|412530","卢氏县|412531","栾川县|412532","临汝县|412533","宜阳县|412534"});
        map.put("0_15_20", new String[]{"周口市|412701","项城市|412702","扶沟县|412721","西华县|412722","商水县|412723","太康县|412724","鹿邑县|412725","郸城县|412726","淮阳县|412727","沈丘县|412728"});
        map.put("0_15_21", new String[]{"驻马店市|412801","确山县|412821","泌阳县|412822","遂平县|412823","西平县|412824","上蔡县|412825","汝南县|412826","平舆县|412827","新蔡县|412828","正阳县|412829"});
        map.put("0_15_22", new String[]{"卧龙区|412901","邓州市|412902","宛城区|412903","南召县|412921","方城县|412922","西峡县|412923","南阳县|412924","镇平县|412925","内乡县|412926","淅川县|412927","社旗县|412928","唐河县|412929","邓县|412930","新野县|412931","桐柏县|412932","规划控制区|412933"});
        map.put("0_15_23", new String[]{"信阳市|413001","息县|413021","淮滨县|413022","平桥区|413023","潢川县|413024","光山县|413025","固始县|413026","商城县|413027","罗山县|413028","新县|413029"});
        map.put("0_15", new String[]{"鹤壁市|410600","新乡市|410700","焦作市|410800","濮阳市|410900","许昌市|411000","漯河市|411100","三门峡市|411200","南阳市|411300","郑州市|410100","开封市|410200","洛阳市|410300","平顶山市|410400","安阳市|410500","商丘市|411400","信阳市|411500","周口市|411600","驻马店市|411700","商丘地区|412300","开封地区|412400","三门峡市|412500","周口地区|412700","驻马店地区|412800","南阳市|412900","信阳地区|413000","许昌市|412601","漯河市|412602","长葛县|412621","禹县|412622","鄢陵县|412623","许昌县|412624","郏县|412625","临颍县|412626","襄城县|412627","宝丰县|412628","郾城县|412629","叶县|412630","鲁山县|412631","舞阳县|412632","义马市|419001","汝州市|419002","济源市|419003","禹州市|419004","卫辉市|419005","辉县市|419006"});
        map.put("0_16_0", new String[]{"市辖区|420501","西陵区|420502","伍家岗区|420503","点军区|420504","猇亭区|420505","夷陵区|420506","宜昌县|420521","枝江县|420523","远安县|420525","兴山县|420526","秭归县|420527","长阳土家族自治县|420528","五峰土家族自治县|420529","宜都市|420581","当阳市|420582","枝江市|420583"});
        map.put("0_16_1", new String[]{"市辖区|420601","襄城区|420602","樊东区|420603","樊西区|420604","郊区|420605","樊城区|420606","襄阳区|420607","随州市|420619","老河口市|420620","襄阳县|420621","枣阳县|420622","宜城县|420623","南漳县|420624","谷城县|420625","保康县|420626","随州市|420681","老河口市|420682","枣阳市|420683","宜城市|420684"});
        map.put("0_16_2", new String[]{"市辖区|420701","梁子湖区|420702","华容区|420703","鄂城区|420704"});
        map.put("0_16_3", new String[]{"市辖区|420801","东宝区|420802","沙洋区|420803","掇刀区|420804","京山县|420821","沙洋县|420822","钟祥市|420881"});
        map.put("0_16_4", new String[]{"市辖区|420901","孝南区|420902","孝昌县|420921","大悟县|420922","云梦县|420923","应城市|420981","安陆市|420982","广水市|420983","汉川市|420984"});
        map.put("0_16_5", new String[]{"市辖区|421001","沙市区|421002","荆州区|421003","江陵区|421004","松滋县|421021","公安县|421022","监利县|421023","江陵县|421024","石首市|421081","洪湖市|421083","松滋市|421087"});
        map.put("0_16_6", new String[]{"市辖区|421101","黄州区|421102","龙感湖管理区|421103","团风县|421121","红安县|421122","罗田县|421123","英山县|421124","浠水县|421125","蕲春县|421126","黄梅县|421127","麻城市|421181","武穴市|421182"});
        map.put("0_16_7", new String[]{"市辖区|421201","咸安区|421202","嘉鱼县|421221","通城县|421222","崇阳县|421223","通山县|421224","赤壁市|421281"});
        map.put("0_16_8", new String[]{"市辖区|421301","曾都区|421302","广水市|421381"});
        map.put("0_16_9", new String[]{"鄂州市|422101","武穴市|422102","黄州市|422103","黄冈县|422121","新洲县|422122","红安县|422123","麻城县|422124","罗田县|422125","英山县|422126","浠水县|422127","蕲春县|422128","广济县|422129","黄梅县|422130","鄂城县|422131"});
        map.put("0_16_10", new String[]{"孝感市|422201","应城市|422202","安陆市|422203","广水市|422204","孝感县|422221","黄陂县|422222","大悟县|422223","应山县|422224","安陆县|422225","云梦县|422226","应城县|422227","汉川县|422228"});
        map.put("0_16_11", new String[]{"神农架林区|422921"});
        map.put("0_16_12", new String[]{"随州市|429001","枣阳市|429003","仙桃市|429004","潜江市|429005","天门市|429006","神农架林区|429021"});
        map.put("0_16_13", new String[]{"市辖区|420101","江岸区|420102","江汉区|420103","乔口区|420104","汉阳区|420105","武昌区|420106","青山区|420107","东湖管理分局|420109","洪山区|420111","东西湖区|420112","汉南区|420113","蔡甸区|420114","江夏区|420115","黄陂区|420116","新洲区|420117","蔡甸区|420121","江夏区|420122","黄陂区|420123","新洲县|420124"});
        map.put("0_16_14", new String[]{"市辖区|420201","黄石港区|420202","石灰窑区|420203","下陆区|420204","铁山区|420205","市区|420220","大冶县|420221","阳新县|420222","大冶市|420281"});
        map.put("0_16_15", new String[]{"市辖区|420301","茅箭区|420302","张湾区|420303","郧县|420321","郧西县|420322","竹山县|420323","竹溪县|420324","房县|420325","丹江口市|420381"});
        map.put("0_16_17", new String[]{"咸宁市|422301","赤壁市|422302","咸宁县|422321","嘉鱼县|422322","蒲圻县|422323","通城县|422324","崇阳县|422325","通山县|422326","阳新县|422327"});
        map.put("0_16_18", new String[]{"仙桃市|422401","石首市|422402","洪湖市|422403","天门市|422404","潜江市|422405","钟祥市|422406","江陵县|422421","松滋县|422422","公安县|422423","石首县|422424","监利县|422425","洪湖县|422426","沔阳县|422427","天门县|422428","潜江县|422429","荆门县|422430","钟祥县|422431","京山县|422432"});
        map.put("0_16_19", new String[]{"随州市|422501","老河口市|422502","襄阳县|422521","枣阳县|422522","宜城县|422524","南漳县|422525","谷城县|422527","保康县|422528"});
        map.put("0_16_20", new String[]{"丹江口市|422601","郧县|422622","郧西县|422623","竹山县|422624","竹溪县|422625","房县|422626","神农架林区|422627"});
        map.put("0_16_21", new String[]{"枝城市|422701","当阳市|422702","宜昌县|422721","宜都县|422722","枝江县|422723","当阳县|422724","远安县|422725","兴山县|422726","秭归县|422727","长阳土家族自治县|422728","五峰土家族自治县|422729"});
        map.put("0_16_22", new String[]{"恩施市|422801","利川市|422802","建始县|422822","巴东县|422823","宣恩县|422825","咸丰县|422826","来凤县|422827","鹤峰县|422828"});
        map.put("0_16", new String[]{"宜昌市|420500","襄樊市|420600","鄂州市|420700","荆门市|420800","孝感市|420900","荆州市|421000","黄冈市|421100","咸宁市|421200","随州市|421300","黄冈地区|422100","孝感地区|422200","省直辖行政单位|422900","省直辖行政单位|429000","武汉市|420100","黄石市|420200","十堰市|420300","沙市|420400","咸宁地区|422300","荆州地区|422400","随州地区|422500","郧阳地区|422600","宜昌地区|422700","恩施土家族苗族自治州|422800","沙洋监狱管理局|423022"});
        map.put("0_17_0", new String[]{"市辖区|430101","芙蓉区|430102","天心区|430103","岳麓区|430104","开福区|430105","雨花区|430111","市区|430120","长沙县|430121","望城县|430122","浏阳县|430123","宁乡县|430124","浏阳市|430181"});
        map.put("0_17_1", new String[]{"市辖区|430201","荷塘区|430202","芦淞区|430203","石峰区|430204","天元区|430211","醴陵市|430219","市区|430220","株洲县|430221","醴陵县|430222","攸县|430223","茶陵县|430224","炎陵县|430225","醴陵市|430281"});
        map.put("0_17_2", new String[]{"市辖区|430301","雨湖区|430302","湘江区|430303","岳塘区|430304","板塘区|430305","韶山区|430306","郊区|430311","韶山区|430312","湘潭县|430321","湘乡县|430322","湘乡市|430381","韶山市|430382"});
        map.put("0_17_3", new String[]{"市辖区|430401","江东区|430402","城南区|430403","城北区|430404","珠晖区|430405","雁峰区|430406","石鼓区|430407","蒸湘区|430408","郊区|430411","南岳区|430412","耒阳市|430419","衡阳县|430421","衡南县|430422","衡山县|430423","衡东县|430424","常宁县|430425","祁东县|430426","耒阳县|430427","耒阳市|430481","常宁市|430482"});
        map.put("0_17_4", new String[]{"湘潭县|432121","湘乡县|432122","醴陵县|432123","浏阳县|432124","攸县|432125","茶陵县|432126","酃县|432127"});
        map.put("0_17_5", new String[]{"岳阳市|432201","平江县|432222","湘阴县|432223","汨罗县|432224","临湘市|432225","华容县|432226"});
        map.put("0_17_6", new String[]{"益阳市|432301","沅江市|432302","益阳县|432321","南县|432322","沅江县|432323","宁乡县|432324","桃江县|432325","安化县|432326"});
        map.put("0_17_7", new String[]{"常德市|432401","津市市|432402","常德县|432421","安乡县|432422","汉寿县|432423","澧县|432424","临澧县|432425","桃源县|432426","石门县|432427","慈利县|432428"});
        map.put("0_17_8", new String[]{"娄底市|432501","冷水江市|432502","涟源市|432503","涟源县|432521","双峰县|432522","邵东县|432523","新化县|432524","新邵县|432525"});
        map.put("0_17_9", new String[]{"邵阳县|432621","隆回县|432622","武冈县|432623","洞口县|432624","新宁县|432625","绥宁县|432626","城步苗族自治县|432627"});
        map.put("0_17_10", new String[]{"衡阳县|432721","衡南县|432722","衡山县|432723","衡东县|432724","常宁县|432725","祁东县|432726","祁阳县|432727"});
        map.put("0_17_11", new String[]{"郴州市|432801","资兴市|432802","郴县|432821","桂阳县|432822","永兴县|432823","宜章县|432824","资兴县|432825","嘉禾县|432826","临武县|432827","汝城县|432828","桂东县|432829","耒阳县|432830","安仁县|432831"});
        map.put("0_17_12", new String[]{"永州市|432901","冷水滩市|432902","零陵县|432921","东安县|432922","道县|432923","宁远县|432924","江永县|432925","江华瑶族自治县|432926","蓝山县|432927","新田县|432928","双牌县|432929","双牌县|432930"});
        map.put("0_17_13", new String[]{"市辖区|430501","双清区|430502","大祥区|430503","北塔区|430511","邵东县|430521","新邵县|430522","邵阳县|430523","隆回县|430524","洞口县|430525","武冈县|430526","绥宁县|430527","新宁县|430528","城步苗族自治县|430529","武冈市|430581"});
        map.put("0_17_14", new String[]{"市辖区|430601","岳阳楼区|430602","云溪区|430603","君山区|430611","岳阳县|430621","临湘县|430622","华容县|430623","湘阴县|430624","汨罗县|430625","平江县|430626","汨罗市|430681","临湘市|430682"});
        map.put("0_17_15", new String[]{"市辖区|430701","武陵区|430702","鼎城区|430703","安乡县|430721","汉寿县|430722","澧县|430723","临澧县|430724","桃源县|430725","石门县|430726","津市市|430781"});
        map.put("0_17_16", new String[]{"市辖区|430801","永定区|430802","武陵源区|430811","慈利县|430821","桑植县|430822"});
        map.put("0_17_17", new String[]{"市辖区|430901","资阳区|430902","赫山区|430903","市区|430911","南县|430921","桃江县|430922","安化县|430923","沅江市|430981"});
        map.put("0_17_18", new String[]{"市辖区|431001","北湖区|431002","苏仙区|431003","桂阳县|431021","宜章县|431022","永兴县|431023","嘉禾县|431024","临武县|431025","汝城县|431026","桂东县|431027","安仁县|431028","资兴市|431081"});
        map.put("0_17_19", new String[]{"市辖区|431101","零陵区|431102","冷水滩区|431103","祁阳县|431121","东安县|431122","双牌县|431123","道县|431124","江永县|431125","宁远县|431126","蓝山县|431127","新田县|431128","江华瑶族自治县|431129"});
        map.put("0_17_20", new String[]{"市辖区|431201","鹤城区|431202","中方县|431221","沅陵县|431222","辰溪县|431223","溆浦县|431224","会同县|431225","麻阳苗族自治县|431226","新晃侗族自治县|431227","芷江侗族自治县|431228","靖州苗族侗族自治县|431229","通道侗族自治县|431230","洪江市|431281"});
        map.put("0_17_21", new String[]{"市辖区|431301","娄星区|431302","双峰县|431321","新化县|431322","冷水江市|431381","涟源市|431382"});
        map.put("0_17_22", new String[]{"怀化市|433001","洪江市|433002","黔阳县|433021","沅陵县|433022","辰溪县|433023","溆浦县|433024","麻阳县|433025","新晃侗族自治县|433026","芷江县|433027","怀化县|433028","会同县|433029","靖县|433030","通道侗族自治县|433031"});
        map.put("0_17_23", new String[]{"吉首市|433101","吉首县|433121","泸溪县|433122","凤凰县|433123","花垣县|433124","保靖县|433125","古丈县|433126","永顺县|433127","大庸县|433128","桑植县|433129","龙山县|433130"});
        map.put("0_17", new String[]{"长沙市|430100","株洲市|430200","湘潭市|430300","衡阳市|430400","湘潭地区|432100","岳阳地区|432200","益阳地区|432300","常德地区|432400","娄底地区|432500","邵阳地区|432600","衡阳地区|432700","郴州地区|432800","零陵地区|432900","邵阳市|430500","岳阳市|430600","常德市|430700","张家界市|430800","益阳市|430900","郴州市|431000","永州市|431100","怀化市|431200","娄底市|431300","怀化地区|433000","湘西土家族苗族自治州|433100","醴陵市|439001","湘乡市|439002","耒阳市|439003","汨罗市|439004","津市市|439005"});
        map.put("0_18_0", new String[]{"市辖区|440101","东山区|440102","荔湾区|440103","越秀区|440104","海珠区|440105","天河区|440106","芳村区|440107","白云区|440111","黄埔区|440112","番禺区|440113","花都区|440114","南沙区|440115","萝岗区|440116","市区|440120","花县|440121","从化县|440122","新丰县|440123","龙门县|440124","增城县|440125","番禺县|440126","清远县|440127","佛冈县|440128","番禺市|440181","花都市|440182","增城市|440183","从化市|440184"});
        map.put("0_18_1", new String[]{"市辖区|440201","北江区|440202","武江区|440203","浈江区|440204","曲江区|440205","曲江县|440221","始兴县|440222","南雄县|440223","仁化县|440224","乐昌县|440225","连县|440226","阳山县|440227","英德县|440228","翁源县|440229","连山壮族瑶族自治县|440230","连南瑶族自治县|440231","乳源瑶族自治县|440232","新丰县|440233","乐昌市|440281","南雄市|440282"});
        map.put("0_18_2", new String[]{"市辖区|440301","盐田区|440302","罗湖区|440303","福田区|440304","南山区|440305","宝安区|440306","龙岗区|440307","盐田区|440308","市区|440320","宝安县|440321"});
        map.put("0_18_3", new String[]{"市辖区|440401","香洲区|440402","斗门区|440403","金湾区|440404","斗门县|440421"});
        map.put("0_18_4", new String[]{"市辖区|440501","同平区|440502","安平区|440503","公园区|440504","金砂区|440505","达濠区|440506","龙湖区|440507","金园区|440508","升平区|440509","河浦区|440510","金平区|440511","濠江区|440512","潮阳区|440513","潮南区|440514","澄海区|440515","潮州市|440520","澄海县|440521","饶平县|440522","南澳县|440523","潮阳县|440524","揭阳县|440525","揭西县|440526","普宁县|440527","惠来县|440528","潮州市|440581","潮阳市|440582","澄海市|440583"});
        map.put("0_18_5", new String[]{"市辖区|440601","城区|440602","石湾区|440603","禅城区|440604","南海区|440605","顺德区|440606","三水区|440607","高明区|440608","中山市|440620","三水县|440621","南海县|440622","顺德县|440623","高明县|440624","顺德市|440681","南海市|440682","三水市|440683","高明市|440684"});
        map.put("0_18_6", new String[]{"市辖区|440701","城区|440702","蓬江区|440703","江海区|440704","新会区|440705","郊区|440711","新会县|440721","台山县|440722","恩平县|440723","开平县|440724","鹤山县|440725","阳江县|440726","阳春县|440727","台山市|440781","新会市|440782","开平市|440783","鹤山市|440784","恩平市|440785"});
        map.put("0_18_7", new String[]{"连州市|441882","市辖区|441801","清城区|441802","清郊区|441811","佛冈县|441821","英德县|441822","阳山县|441823","连县|441824","连山壮族瑶族自治县|441825","连南瑶族自治县|441826","清新县|441827","英德市|441881"});
        map.put("0_18_10", new String[]{"佛山市|442701","江门市|442702","三水县|442721","南海县|442722","顺德县|442723","中山县|442724","斗门县|442725","新会县|442726","台山县|442727","恩平县|442728","开平县|442729","鹤山县|442731","高明县|442732"});
        map.put("0_18_11", new String[]{"湛江市|442901","茂名市|442902","阳江县|442921","阳春县|442922","信宜县|442923","高州县|442924","电白县|442925","吴川县|442926","化州县|442927","廉江县|442928","遂溪县|442929","海康县|442930","徐闻县|442931"});
        map.put("0_18_12", new String[]{"市辖区|445101","湘桥区|445102","潮安县|445121","饶平县|445122"});
        map.put("0_18_13", new String[]{"市辖区|445201","榕城区|445202","揭东县|445221","揭西县|445222","惠来县|445224","普宁市|445281"});
        map.put("0_18_14", new String[]{"市辖区|440801","赤坎区|440802","霞山区|440803","坡头区|440804","麻章区|440811","吴川县|440821","廉江县|440822","遂溪县|440823","海康县|440824","徐闻县|440825","廉江市|440881","雷州市|440882","吴川市|440883"});
        map.put("0_18_15", new String[]{"市辖区|440901","茂南区|440902","茂港区|440903","信宜县|440921","高州县|440922","电白县|440923","化州县|440924","高州市|440981","化州市|440982","信宜市|440983"});
        map.put("0_18_16", new String[]{"市辖区|441201","端州区|441202","鼎湖区|441203","高要县|441221","四会县|441222","广宁县|441223","怀集县|441224","封开县|441225","德庆县|441226","云浮县|441227","新兴县|441228","郁南县|441229","罗定县|441230","云浮市|441281","罗定市|441282","高要市|441283","四会市|441284"});
        map.put("0_18_17", new String[]{"市辖区|441301","惠城区|441302","惠阳区|441303","惠阳县|441321","博罗县|441322","惠东县|441323","龙门县|441324","惠阳市|441381"});
        map.put("0_18_18", new String[]{"市辖区|441401","梅江区|441402","梅县|441421","大埔县|441422","丰顺县|441423","五华县|441424","兴宁县|441425","平远县|441426","蕉岭县|441427","兴宁市|441481"});
        map.put("0_18_19", new String[]{"市辖区|441501","城区|441502","海丰县|441521","陆丰县|441522","陆河县|441523","陆丰市|441581"});
        map.put("0_18_20", new String[]{"市辖区|441601","源城区|441602","郊区|441611","紫金县|441621","龙川县|441622","连平县|441623","和平县|441624","东源县|441625"});
        map.put("0_18_21", new String[]{"市辖区|441701","江城区|441702","阳东区|441703","阳西县|441721","阳春县|441722","阳东县|441723","阳春市|441781"});
        map.put("0_18_22", new String[]{"市辖区|445301","云城区|445302","新兴县|445321","郁南县|445322","云安县|445323","罗定市|445381"});
        map.put("0_18", new String[]{"广州市|440100","韶关市|440200","深圳市|440300","珠海市|440400","汕头市|440500","佛山市|440600","江门市|440700","清远市|441800","东莞市|441900","中山市|442000","佛山市|442700","湛江市|442900","潮州市|445100","揭阳市|445200","湛江市|440800","茂名市|440900","肇庆市|441200","惠州市|441300","梅州市|441400","汕尾市|441500","河源市|441600","阳江市|441700","云浮市|445300","连平县|442524","河源县|442525","博罗县|442526","东莞县|442527","惠东县|442528","龙川县|442529","陆丰县|442530","海丰县|442531","始兴县|442621","南雄县|442622","仁化县|442623","乐昌县|442624","清远县|442628","翁源县|442630","连山壮族瑶族自治县|442631","连南瑶族自治县|442632","乳源瑶族自治县|442633","高要县|442821","四会县|442822","广宁县|442823","怀集县|442824","封开县|442825","德庆县|442826","云浮县|442827","新兴县|442828","郁南县|442829","罗定县|442830","惠州市|442501","东莞市|442502","惠阳县|442521","紫金县|442522","和平县|442523"});
        map.put("0_19_0", new String[]{"市辖区|451001","右江区|451002","田阳县|451021","田东县|451022","平果县|451023","德保县|451024","靖西县|451025","那坡县|451026","凌云县|451027","乐业县|451028","田林县|451029","西林县|451030","隆林各族自治县|451031"});
        map.put("0_19_1", new String[]{"市辖区|451101","八步区|451102","昭平县|451121","钟山县|451122","富川瑶族自治县|451123"});
        map.put("0_19_2", new String[]{"市辖区|451201","金城江区|451202","南丹县|451221","天峨县|451222","凤山县|451223","东兰县|451224","罗城仫佬族自治县|451225","环江毛南族自治县|451226","巴马瑶族自治县|451227","都安瑶族自治县|451228","大化瑶族自治县|451229","宜州市|451281"});
        map.put("0_19_3", new String[]{"市辖区|451301","兴宾区|451302","忻城县|451321","象州县|451322","武宣县|451323","金秀瑶族自治县|451324","合山市|451381"});
        map.put("0_19_4", new String[]{"市辖区|451401","江洲区|451402","扶绥县|451421","宁明县|451422","龙州县|451423","大新县|451424","天等县|451425","凭祥市|451481"});
        map.put("0_19_5", new String[]{"凭祥市|452101","横县|452122","宾阳县|452123","上林县|452124","隆安县|452126","马山县|452127","扶绥县|452128","崇左县|452129","大新县|452130","天等县|452131","宁明县|452132","龙州县|452133"});
        map.put("0_19_6", new String[]{"合山市|452201","鹿寨县|452223","象州县|452224","武宣县|452225","来宾县|452226","融安县|452227","三江侗族自治县|452228","融水苗族自治县|452229","金秀瑶族自治县|452230","忻城县|452231"});
        map.put("0_19_7", new String[]{"市辖区|450101","兴宁区|450102","青秀区|450103","城北区|450104","江南区|450105","永新区|450106","西乡塘区|450107","良庆区|450108","邕宁区|450109","郊区|450111","邕宁县|450121","武鸣县|450122","隆安县|450123","马山县|450124","上林县|450125","宾阳县|450126","横县|450127"});
        map.put("0_19_8", new String[]{"市辖区|450201","城中区|450202","鱼峰区|450203","柳南区|450204","柳北区|450205","市郊区|450211","柳江县|450221","柳城县|450222","鹿寨县|450223","融安县|450224","融水苗族自治县|450225","三江侗族自治县|450226"});
        map.put("0_19_9", new String[]{"市辖区|450301","秀峰区|450302","叠彩区|450303","象山区|450304","七星区|450305","雁山区|450311","阳朔县|450321","临桂县|450322","灵川县|450323","全州县|450324","兴安县|450325","永福县|450326","灌阳县|450327","龙胜各族自治县|450328","资源县|450329","平乐县|450330","荔蒲县|450331","恭城瑶族自治县|450332"});
        map.put("0_19_10", new String[]{"市辖区|450401","白云区|450402","万秀区|450403","蝶山区|450404","长洲区|450405","市郊区|450411","苍梧县|450421","藤县|450422","蒙山县|450423","岑溪市|450481"});
        map.put("0_19_11", new String[]{"市辖区|450501","海城区|450502","银海区|450503","铁山港区|450512","合浦县|450521"});
        map.put("0_19_12", new String[]{"市辖区|450601","港口区|450602","防城区|450603","上思县|450621","东兴市|450681"});
        map.put("0_19_13", new String[]{"市辖区|450701","钦南区|450702","钦北区|450703","灵山县|450721","浦北县|450722"});
        map.put("0_19_14", new String[]{"市辖区|450801","港北区|450802","港南区|450803","覃塘区|450804","平南县|450821","桂平市|450881"});
        map.put("0_19_15", new String[]{"市辖区|450901","玉州区|450902","容县|450921","陆川县|450922","博白县|450923","兴业县|450924","北流市|450981"});
        map.put("0_19_16", new String[]{"临桂县|452321","灵川县|452322","全州县|452323","兴安县|452324","永福县|452325","灌阳县|452327","龙胜各族自治县|452328","资源县|452329","平乐县|452330","荔蒲县|452331","恭城瑶族自治县|452332"});
        map.put("0_19_17", new String[]{"岑溪市|452401","贺州市|452402","岑溪县|452421","苍梧县|452422","藤县|452423","昭平县|452424","蒙山县|452425","贺县|452426","钟山县|452427","富川瑶族自治县|452428"});
        map.put("0_19_18", new String[]{"玉林市|452501","贵港市|452502","北流市|452503","桂平市|452504","玉林县|452521","贵县|452522","桂平县|452523","平南县|452524","容县|452525","北流县|452526","陆川县|452527","博白县|452528"});
        map.put("0_19_19", new String[]{"百色市|452601","百色县|452621","田阳县|452622","田东县|452623","平果县|452624","德保县|452625","靖西县|452626","那坡县|452627","凌云县|452628","乐业县|452629","田林县|452630","隆林各族自治县|452631","西林县|452632"});
        map.put("0_19_20", new String[]{"河池市|452701","宜州市|452702","河池县|452721","宜山县|452722","罗城仫佬族自治县|452723","环江毛南族自治县|452724","南丹县|452725","天峨县|452726","凤山县|452727","东兰县|452728","巴马瑶族自治县|452729","都安瑶族自治县|452730","大化瑶族自治县|452731"});
        map.put("0_19_21", new String[]{"北海市|452801","钦州市|452802","上思县|452821","防城各族自治县|452822","钦州县|452823","灵山县|452824","合浦县|452825","浦北县|452826"});
        map.put("0_19", new String[]{"百色市|451000","贺州市|451100","河池市|451200","来宾市|451300","崇左市|451400","南宁地区|452100","柳州地区|452200","南宁市|450100","柳州市|450200","桂林市|450300","梧州市|450400","北海市|450500","防城港市|450600","钦州市|450700","贵港市|450800","玉林市|450900","桂林地区|452300","贺州地区|452400","玉林地区|452500","百色地区|452600","河池地区|452700","钦州地区|452800"});
        map.put("0_20_0", new String[]{"市辖区|460101","振东区|460102","新华区|460103","秀英区|460104","秀英区|460105","龙华区|460106","琼山区|460107","美兰区|460108"});
        map.put("0_20_1", new String[]{"市辖区|460201"});
        map.put("0_20", new String[]{"海口市|460100","三亚市|460200","陵水黎族自治县|469034","保亭黎族苗族自治县|469035","琼中黎族苗族自治县|469036","西沙群岛|469037","南沙群岛|469038","中沙群岛的岛礁及其海域|469039","通什市|460001","琼海市|460002","儋州市|460003","琼山市|460004","文昌市|460005","万宁市|460006","东方市|460007","琼山县|460021","文昌县|460022","琼海县|460023","万宁县|460024","定安县|460025","屯昌县|460026","澄迈县|460027","临高县|460028","儋县|460029","白沙黎族自治县|460030","昌江黎族自治县|460031","东方黎族自治县|460032","乐东黎族自治县|460033","陵水黎族自治县|460034","保亭黎族苗族自治县|460035","琼中黎族苗族自治县|460036","西沙群岛|460037","南沙群岛|460038","中沙群岛的岛礁及其海域|460039","五指山市|469001","琼海市|469002","儋州市|469003","文昌市|469005","万宁市|469006","东方市|469007","定安县|469025","屯昌县|469026","澄迈县|469027","临高县|469028","白沙黎族自治县|469030","昌江黎族自治县|469031","乐东黎族自治县|469033"});
        map.put("0_21_0", new String[]{"江津市|500381","合川市|500382","永川市|500383","南川市|500384"});
        map.put("0_21", new String[]{"市|500300","万州区|500101","涪陵区|500102","渝中区|500103","大渡口区|500104","江北区|500105","沙坪坝区|500106","九龙坡区|500107","南岸区|500108","北碚区|500109","万盛区|500110","双桥区|500111","渝北区|500112","巴南区|500113","黔江区|500114","长寿区|500115","渝中区|500201","江北区|500211","沙坪坝区|500212","九龙坡区|500213","南岸区|500214","北碚区|500215","万盛区|500216","双桥区|500217","长寿县|500221","綦江县|500222","潼南县|500223","铜梁县|500224","大足县|500225","荣昌县|500226","璧山县|500227","梁平县|500228","城口县|500229","丰都县|500230","垫江县|500231","武隆县|500232","忠县|500233","开县|500234","云阳县|500235","奉节县|500236","巫山县|500237","巫溪县|500238","黔江土家族苗族自治县|500239","石柱土家族自治县|500240","秀山土家族苗族自治县|500241","酉阳土家族苗族自治县|500242","彭水苗族土家族自治县|500243"});
        map.put("0_22_0", new String[]{"市辖区|510301","自流井区|510302","贡井区|510303","大安区|510304","沿滩区|510311","荣县|510321","富顺县|510322"});
        map.put("0_22_1", new String[]{"市辖区|510401","东区|510402","西区|510403","仁和区|510411","米易县|510421","盐边县|510422"});
        map.put("0_22_2", new String[]{"市辖区|510501","江阳区|510502","纳溪区|510503","龙马潭区|510504","泸县|510521","合江县|510522","纳溪县|510523","叙永县|510524","古蔺县|510525"});
        map.put("0_22_3", new String[]{"市辖区|510601","市中区|510602","旌阳区|510603","绵竹县|510622","中江县|510623","广汉县|510624","什邡县|510625","罗江县|510626","广汉市|510681","什邡市|510682","绵竹市|510683"});
        map.put("0_22_4", new String[]{"市辖区|510701","市中区|510702","涪城区|510703","游仙区|510704","江油县|510721","三台县|510722","盐亭县|510723","安县|510724","梓潼县|510725","北川县|510726","平武县|510727","江油市|510781"});
        map.put("0_22_5", new String[]{"市辖区|510801","市中区|510802","元坝区|510811","朝天区|510812","旺苍县|510821","青川县|510822","剑阁县|510823","苍溪县|510824"});
        map.put("0_22_6", new String[]{"市辖区|510901","市中区|510902","船山区|510903","安居区|510904","蓬溪县|510921","射洪县|510922","大英县|510923"});
        map.put("0_22_7", new String[]{"市辖区|511001","市中区|511002","东兴区|511011","内江县|511021","乐至县|511022","安岳县|511023","威远县|511024","资中县|511025","资阳市|511026","简阳县|511027","隆昌县|511028","资阳市|511081"});
        map.put("0_22_8", new String[]{"奉节县|512226","巫山县|512227","巫溪县|512228","城口县|512229","万县市|512201","万县|512221","开县|512222","忠县|512223","梁平县|512224","云阳县|512225"});
        map.put("0_22_9", new String[]{"涪陵市|512301","南川市|512302","涪陵县|512321","垫江县|512322","南川县|512323","丰都县|512324","石柱县|512325","武隆县|512326","彭水县|512327","黔江县|512328","酉阳县|512329","秀山县|512330"});
        map.put("0_22_10", new String[]{"宜宾市|512501","宜宾县|512527","南溪县|512528","江安县|512529","长宁县|512530","高县|512531","筠连县|512532","珙县|512533","兴文县|512534","屏山县|512535"});
        map.put("0_22_11", new String[]{"南充市|512901","华蓥市|512902","阆中市|512903","南充县|512921","南部县|512922","岳池县|512923","营山县|512924","广安县|512925","蓬安县|512926","仪陇县|512927","武胜县|512928","西充县|512929","阆中县|512930","苍溪县|512931","华云工农区|512932"});
        map.put("0_22_12", new String[]{"达川市|513001","万源市|513002","达县|513021","宣汉县|513022","开江县|513023","万源县|513024","通江县|513025","南江县|513026","巴中县|513027","平昌县|513028","大竹县|513029","渠县|513030","邻水县|513031","白沙工农区|513032"});
        map.put("0_22_13", new String[]{"雅安市|513101","名山县|513122","荥经县|513123","汉源县|513124","石棉县|513125","天全县|513126","芦山县|513127","宝兴县|513128"});
        map.put("0_22_14", new String[]{"汶川县|513221","理县|513222","茂县|513223","松潘县|513224","九寨沟县|513225","金川县|513226","小金县|513227","黑水县|513228","马尔康县|513229","壤塘县|513230","阿坝县|513231","若尔盖县|513232","红原县|513233"});
        map.put("0_22_15", new String[]{"康定县|513321","泸定县|513322","丹巴县|513323","九龙县|513324","雅江县|513325","道孚县|513326","炉霍县|513327","甘孜县|513328","新龙县|513329","德格县|513330","白玉县|513331","石渠县|513332","色达县|513333","理塘县|513334","巴塘县|513335","乡城县|513336","稻城县|513337","得荣县|513338"});
        map.put("0_22_16", new String[]{"西昌市|513401","木里藏族自治县|513422","盐源县|513423","德昌县|513424","会理县|513425","会东县|513426","宁南县|513427","普格县|513428","布拖县|513429","金阳县|513430","昭觉县|513431","喜德县|513432","冕宁县|513433","越西县|513434","甘洛县|513435","美姑县|513436","雷波县|513437"});
        map.put("0_22_17", new String[]{"市辖区|510101","东城区|510102","西城区|510103","锦江区|510104","青羊区|510105","金牛区|510106","武侯区|510107","成华区|510108","金牛区|510111","龙泉驿区|510112","青白江区|510113","新都区|510114","市区|510120","金堂县|510121","双流县|510122","温江县|510123","郫县|510124","新都县|510125","彭县|510126","灌县|510127","崇庆县|510128","大邑县|510129","邛崃县|510130","蒲江县|510131","新津县|510132","都江堰市|510181","彭州市|510182","邛崃市|510183","崇州市|510184"});
        map.put("0_22_18", new String[]{"市辖区|510201","市中区|510202","大渡口区|510203","江北区|510211","沙坪坝区|510212","九龙坡区|510213","南岸区|510214","北碚区|510215","万盛区|510216","双桥区|510217","渝北区|510218","巴南区|510219","市区|510220","长寿县|510221","巴县|510222","綦江县|510223","江北县|510224","江津县|510225","合川县|510226","潼南县|510227","铜梁县|510228","永川县|510229","大足县|510230","北碚区|510231","璧山县|510232","永川市|510281","江津市|510282","合川市|510283"});
        map.put("0_22_19", new String[]{"市辖区|511101","市中区|511102","沙湾区|511111","五通桥区|511112","金口河区|511113","仁寿县|511121","眉山县|511122","犍为县|511123","井研县|511124","峨眉县|511125","夹江县|511126","洪雅县|511127","彭山县|511128","沐川县|511129","青神县|511130","丹棱县|511131","峨边彝族自治县|511132","马边彝族自治县|511133","峨眉山市|511181"});
        map.put("0_22_20", new String[]{"市辖区|511201","龙宝区|511202","天成区|511203","五桥区|511204","开县|511221","忠县|511222","梁平县|511223","云阳县|511224","奉节县|511225","巫山县|511226","巫溪县|511227","城口县|511228"});
        map.put("0_22_21", new String[]{"市辖区|511301","顺庆区|511302","高坪区|511303","嘉陵区|511304","南部县|511321","营山县|511322","蓬安县|511323","仪陇县|511324","西充县|511325","阆中市|511381"});
        map.put("0_22_22", new String[]{"市辖区|511401","东坡区|511402","仁寿县|511421","彭山县|511422","洪雅县|511423","丹棱县|511424","青神县|511425"});
        map.put("0_22_23", new String[]{"市辖区|511501","翠屏区|511502","宜宾县|511521","南溪县|511522","江安县|511523","长宁县|511524","高县|511525","珙县|511526","筠连县|511527","兴文县|511528","屏山县|511529"});
        map.put("0_22_24", new String[]{"市辖区|511601","广安区|511602","岳池县|511621","武胜县|511622","邻水县|511623","华蓥市|511681"});
        map.put("0_22_25", new String[]{"市辖区|511701","通川区|511702","达县|511721","宣汉县|511722","开江县|511723","大竹县|511724","渠县|511725","万源市|511781"});
        map.put("0_22_26", new String[]{"市辖区|511801","雨城区|511802","名山县|511821","荥经县|511822","汉源县|511823","石棉县|511824","天全县|511825","芦山县|511826","宝兴县|511827"});
        map.put("0_22_27", new String[]{"市辖区|511901","巴州区|511902","通江县|511921","南江县|511922","平昌县|511923"});
        map.put("0_22_28", new String[]{"市辖区|512001","雁江区|512002","安岳县|512021","乐至县|512022","简阳市|512081"});
        map.put("0_22_29", new String[]{"石柱土家族自治县|513521","秀山土家族苗族自治县|513522","黔江土家族苗族自治县|513523","酉阳土家族苗族自治县|513524"});
        map.put("0_22_30", new String[]{"华蓥市|513601","岳池县|513621","广安县|513622","武胜县|513623","邻水县|513624"});
        map.put("0_22_31", new String[]{"巴中市|513701","通江县|513721","南江县|513722","平昌县|513723"});
        map.put("0_22_32", new String[]{"眉山县|513821","仁寿县|513822","彭山县|513823","洪雅县|513824","丹棱县|513825","青神县|513826"});
        map.put("0_22_33", new String[]{"资阳市|513901","简阳市|513902","安岳县|513921","乐至县|513922"});
        map.put("0_22", new String[]{"自贡市|510300","攀枝花市|510400","泸州市|510500","德阳市|510600","绵阳市|510700","广元市|510800","遂宁市|510900","内江市|511000","万县地区|512200","涪陵地区|512300","宜宾地区|512500","南充地区|512900","达川地区|513000","雅安地区|513100","阿坝藏族羌族自治州|513200","甘孜藏族自治州|513300","凉山彝族自治州|513400","成都市|510100","重庆市|510200","乐山市|511100","万县市|511200","南充市|511300","眉山市|511400","宜宾市|511500","广安市|511600","达州市|511700","雅安市|511800","巴中市|511900","资阳市|512000","黔江地区|513500","广安市|513600","巴中地区|513700","眉山地区|513800","资阳地区|513900","广汉市|519001","江油市|519002","都江堰市|519003","峨眉山市|519004"});
        map.put("0_23_0", new String[]{"市辖区|520101","南明区|520102","云岩区|520103","花溪区|520111","乌当区|520112","白云区|520113","小河区|520114","开阳县|520121","息烽县|520122","修文县|520123","清镇市|520181"});
        map.put("0_23_1", new String[]{"钟山区|520201","盘县特区|520202","六枝特区|520203","水城县|520221","盘县|520222"});
        map.put("0_23_2", new String[]{"市辖区|520301","红花岗区|520302","汇川区|520303","遵义县|520321","桐梓县|520322","绥阳县|520323","正安县|520324","道真仡佬族苗族自治县|520325","务川仡佬族苗族自治县|520326","凤冈县|520327","湄潭县|520328","余庆县|520329","习水县|520330","赤水市|520381","仁怀市|520382"});
        map.put("0_23_3", new String[]{"市辖区|520401","西秀区|520402","平坝县|520421","普定县|520422","镇宁布依族苗族自治县|520423","关岭布依族苗族自治县|520424","紫云苗族布依族自治县|520425"});
        map.put("0_23_4", new String[]{"遵义市|522101","赤水市|522102","仁怀市|522103","遵义县|522121","桐梓县|522122","绥阳县|522123","正安县|522124","道真仡佬族苗族自治县|522125","务川仡佬族苗族自治县|522126","凤冈县|522127","湄潭县|522128","余庆县|522129","仁怀县|522130","赤水县|522131","习水县|522132"});
        map.put("0_23_5", new String[]{"铜仁市|522201","铜仁县|522221","江口县|522222","玉屏侗族自治县|522223","石阡县|522224","思南县|522225","印江土家族苗族自治县|522226","德江县|522227","沿河土家族自治县|522228","松桃苗族自治县|522229","万山特区|522230"});
        map.put("0_23_6", new String[]{"兴义市|522301","赤壁市|522302","兴义县|522321","兴仁县|522322","普安县|522323","晴隆县|522324","贞丰县|522325","望谟县|522326","册亨县|522327","安龙县|522328"});
        map.put("0_23_7", new String[]{"毕节市|522401","毕节县|522421","大方县|522422","黔西县|522423","金沙县|522424","织金县|522425","纳雍县|522426","威宁彝族回族苗族自治县|522427","赫章县|522428"});
        map.put("0_23_8", new String[]{"安顺市|522501","清镇市|522502","安顺县|522521","开阳县|522522","息烽县|522523","修文县|522524","清镇县|522525","平坝县|522526","普定县|522527","关岭布依族苗族自治县|522528","镇宁布依族苗族自治县|522529","紫云苗族布依族自治县|522530"});
        map.put("0_23_9", new String[]{"凯里市|522601","黄平县|522622","施秉县|522623","三穗县|522624","镇远县|522625","岑巩县|522626","天柱县|522627","锦屏县|522628","剑河县|522629","台江县|522630","黎平县|522631","榕江县|522632","从江县|522633","雷山县|522634","麻江县|522635","丹寨县|522636"});
        map.put("0_23_10", new String[]{"都匀市|522701","福泉市|522702","荔波县|522722","贵定县|522723","福泉县|522724","瓮安县|522725","独山县|522726","平塘县|522727","罗甸县|522728","长顺县|522729","龙里县|522730","惠水县|522731","三都水族自治县|522732"});
        map.put("0_23", new String[]{"贵阳市|520100","六盘水市|520200","遵义市|520300","安顺市|520400","遵义地区|522100","铜仁地区|522200","黔西南布依族苗族自治州|522300","毕节地区|522400","安顺地区|522500","黔东南苗族侗族自治州|522600","黔南布依族苗族自治州|522700"});
        map.put("0_24_0", new String[]{"威信县|530629","水富县|530630","市辖区|530601","昭阳区|530602","鲁甸县|530621","巧家县|530622","盐津县|530623","大关县|530624","永善县|530625","绥江县|530626","镇雄县|530627","彝良县|530628"});
        map.put("0_24_1", new String[]{"市辖区|530701","古城区|530702","玉龙纳西族自治县|530721","永胜县|530722","华坪县|530723","宁蒗彝族自治县|530724"});
        map.put("0_24_2", new String[]{"市辖区|530801","翠云区|530802","普洱哈尼族彝族自治县|530821","墨江哈尼族自治县|530822","景东彝族自治县|530823","景谷傣族彝族自治县|530824","镇沅彝族哈尼族拉祜族自治县|530825","江城哈尼族彝族自治县|530826","孟连傣族拉祜族佤族自治县|530827","澜沧拉祜族自治县|530828","西盟佤族自治县|530829"});
        map.put("0_24_3", new String[]{"市辖区|530901","临翔区|530902","凤庆县|530921","云县|530922","永德县|530923","镇康县|530924","双江拉祜族佤族布朗族傣族自治县|530925","耿马傣族佤族自治县|530926","沧源佤族自治县|530927"});
        map.put("0_24_4", new String[]{"昭通市|532101","鲁甸县|532122","巧家县|532123","盐津县|532124","大关县|532125","永善县|532126","绥江县|532127","镇雄县|532128","彝良县|532129","威信县|532130","水富县|532131"});
        map.put("0_24_5", new String[]{"麒麟区|532201","曲靖县|532221","沾益县|532222","马龙县|532223","宣威市|532224","富源县|532225","罗平县|532226","师宗县|532227","陆良县|532228","宜良县|532229","路南彝族自治县|532230","寻甸回族彝族自治县|532231","嵩明县|532232","会泽县|532233"});
        map.put("0_24_6", new String[]{"楚雄市|532301","楚雄县|532321","双柏县|532322","牟定县|532323","南华县|532324","姚安县|532325","大姚县|532326","永仁县|532327","元谋县|532328","武定县|532329","禄劝县|532330","禄丰县|532331"});
        map.put("0_24_7", new String[]{"龙陵县|533024","昌宁县|533025","保山市|533001","施甸县|533022","腾冲县|533023"});
        map.put("0_24_8", new String[]{"畹町市|533101","瑞丽市|533102","潞西市|533103","潞西县|533121","梁河县|533122","盈江县|533123","陇川县|533124","瑞丽县|533125","畹町镇|533126"});
        map.put("0_24_9", new String[]{"丽江纳西族自治县|533221","永胜县|533222","华坪县|533223","宁蒗彝族自治县|533224"});
        map.put("0_24_10", new String[]{"泸水县|533321","碧江县|533322","福贡县|533323","贡山独龙族怒族自治县|533324","兰坪白族普米族自治县|533325"});
        map.put("0_24_11", new String[]{"市辖区|530101","五华区|530102","盘龙区|530103","官渡区|530111","西山区|530112","东川区|530113","呈贡县|530121","晋宁县|530122","安宁县|530123","富民县|530124","宜良县|530125","石林彝族自治县|530126","嵩明县|530127","禄劝彝族苗族自治县|530128","寻甸回族彝族自治县|530129","安宁市|530181"});
        map.put("0_24_12", new String[]{"市辖区|530301","麒麟区|530302","马龙县|530321","陆良县|530322","师宗县|530323","罗平县|530324","富源县|530325","会泽县|530326","沾益县|530328","宣威市|530381"});
        map.put("0_24_13", new String[]{"市辖区|530401","红塔区|530402","江川县|530421","澄江县|530422","通海县|530423","华宁县|530424","易门县|530425","峨山彝族自治县|530426","新平彝族傣族自治县|530427","元江哈尼族彝族傣族自治县|530428"});
        map.put("0_24_14", new String[]{"市辖区|530501","隆阳区|530502","施甸县|530521","腾冲县|530522","龙陵县|530523","昌宁县|530524"});
        map.put("0_24_15", new String[]{"玉溪市|532401","玉溪县|532421","江川县|532422","澄江县|532423","通海县|532424","华宁县|532425","易门县|532426","峨山彝族自治县|532427","新平彝族傣族自治县|532428","元江哈尼族彝族傣族自治县|532429"});
        map.put("0_24_16", new String[]{"个旧市|532501","开远市|532502","蒙自县|532522","屏边苗族自治县|532523","建水县|532524","石屏县|532525","弥勒县|532526","泸西县|532527","元阳县|532528","红河县|532529","金平苗族瑶族傣族自治县|532530","绿春县|532531","河口瑶族自治县|532532"});
        map.put("0_24_17", new String[]{"文山县|532621","砚山县|532622","西畴县|532623","麻栗坡县|532624","马关县|532625","丘北县|532626","广南县|532627","富宁县|532628"});
        map.put("0_24_18", new String[]{"思茅市|532701","普洱哈尼族彝族自治县|532722","墨江哈尼族自治县|532723","景东彝族自治县|532724","景谷傣族彝族自治县|532725","镇沅彝族哈尼族拉祜族自治县|532726","江城哈尼族彝族自治县|532727","孟连傣族拉祜族佤族自治县|532728","澜沧拉祜族自治县|532729","西盟佤族自治县|532730"});
        map.put("0_24_19", new String[]{"景洪市|532801","勐海县|532822","勐腊县|532823"});
        map.put("0_24_20", new String[]{"大理市|532901","漾濞彝族自治县|532922","祥云县|532923","宾川县|532924","弥渡县|532925","南涧彝族自治县|532926","巍山彝族回族自治县|532927","永平县|532928","云龙县|532929","洱源县|532930","剑川县|532931","鹤庆县|532932"});
        map.put("0_24_21", new String[]{"香格里拉县|533421","德钦县|533422","维西傈僳族自治县|533423"});
        map.put("0_24_22", new String[]{"临沧县|533521","凤庆县|533522","云县|533523","永德县|533524","彭水苗族土家族自治县|533525","双江拉祜族佤族布朗族傣族自治县|533526","耿马傣族佤族自治县|533527","沧源佤族自治县|533528"});
        map.put("0_24", new String[]{"昭通市|530600","丽江市|530700","思茅市|530800","临沧市|530900","昭通地区|532100","曲靖地区|532200","楚雄彝族自治州|532300","保山地区|533000","德宏傣族景颇族自治州|533100","丽江地区|533200","怒江傈僳族自治州|533300","昆明市|530100","曲靖市|530300","玉溪市|530400","保山市|530500","玉溪地区|532400","红河哈尼族彝族自治州|532500","文山壮族苗族自治州|532600","思茅地区|532700","西双版纳傣族自治州|532800","大理白族自治州|532900","迪庆藏族自治州|533400","临沧地区|533500"});
        map.put("0_25_0", new String[]{"乃东县|542221","扎囊县|542222","贡嘎县|542223","桑日县|542224","琼结县|542225","曲松县|542226","措美县|542227","洛扎县|542228","加查县|542229","朗县|542230","隆子县|542231","错那县|542232","浪卡子县|542233"});
        map.put("0_25_1", new String[]{"日喀则市|542301","日喀则县|542321","南木林县|542322","江孜县|542323","定日县|542324","萨迦县|542325","拉孜县|542326","昂仁县|542327","谢通门县|542328","白朗县|542329","仁布县|542330","康马县|542331","定结县|542332","仲巴县|542333","亚东县|542334","吉隆县|542335","聂拉木县|542336","萨嘎县|542337","岗巴县|542338"});
        map.put("0_25_2", new String[]{"那曲县|542421","嘉黎县|542422","比如县|542423","聂荣县|542424","安多县|542425","申扎县|542426","索县|542427","班戈县|542428","巴青县|542429","尼玛县|542430"});
        map.put("0_25_3", new String[]{"市辖区|540101","城关区|540102","市区|540120","林周县|540121","当雄县|540122","尼木县|540123","曲水县|540124","堆龙德庆县|540125","达孜县|540126","墨竹工卡县|540127","工布江达县|540128","林芝县|540129","米林县|540130","墨脱县|540131"});
        map.put("0_25_4", new String[]{"昌都县|542121","江达县|542122","贡觉县|542123","类乌齐县|542124","丁青县|542125","察雅县|542126","八宿县|542127","左贡县|542128","芒康县|542129","洛隆县|542132","边坝县|542133","盐井县|542134","碧土县|542135","妥坝县|542136","生达县|542137"});
        map.put("0_25_5", new String[]{"普兰县|542521","札达县|542522","噶尔县|542523","日土县|542524","革吉县|542525","改则县|542526","措勤县|542527","隆格尔县|542528"});
        map.put("0_25_6", new String[]{"林芝县|542621","工布江达县|542622","米林县|542623","墨脱县|542624","波密县|542625","察隅县|542626","朗县|542627"});
        map.put("0_25_7", new String[]{"江孜县|542721","浪卡子县|542722","白朗县|542723","仁布县|542724","康马县|542725","亚东县|542726","岗巴县|542727"});
        map.put("0_25", new String[]{"山南地区|542200","日喀则地区|542300","那曲地区|542400","拉萨市|540100","昌都地区|542100","阿里地区|542500","林芝地区|542600","江孜地区|542700"});
        map.put("0_26_0", new String[]{"市辖区|610101","新城区|610102","碑林区|610103","莲湖区|610104","经济开发区|610106","灞桥区|610111","未央区|610112","雁塔区|610113","阎良区|610114","临潼区|610115","长安区|610116","长安县|610121","蓝田县|610122","临潼县|610123","周至县|610124","户县|610125","高陵县|610126"});
        map.put("0_26_1", new String[]{"镇坪县|610927","旬阳县|610928","白河县|610929","市辖区|610901","汉滨区|610902","汉阴县|610921","石泉县|610922","宁陕县|610923","紫阳县|610924","岚皋县|610925","平利县|610926"});
        map.put("0_26_2", new String[]{"市辖区|611001","商州区|611002","洛南县|611021","丹凤县|611022","商南县|611023","山阳县|611024","镇安县|611025","柞水县|611026"});
        map.put("0_26_3", new String[]{"渭南市|612101","韩城市|612102","华阴市|612103","蓝田县|612121","临潼县|612122","渭南县|612123","华县|612124","华阴县|612125","潼关县|612126","大荔县|612127","蒲城县|612128","澄城县|612129","白水县|612130","韩城县|612131","合阳县|612132","富平县|612133"});
        map.put("0_26_4", new String[]{"咸阳市|612201","兴平县|612221","周至县|612222","户县|612223","三原县|612224","泾阳县|612225","高陵县|612226","乾县|612227","礼泉县|612228","永寿县|612229","彬县|612230","长武县|612231","旬邑县|612232","淳化县|612233"});
        map.put("0_26_5", new String[]{"汉中市|612301","南郑县|612321","城固县|612322","洋县|612323","西乡县|612324","勉县|612325","宁强县|612326","略阳县|612327","镇巴县|612328","留坝县|612329","佛坪县|612330"});
        map.put("0_26_6", new String[]{"安康市|612401","安康县|612421","汉阴县|612422","石泉县|612423","宁陕县|612424","紫阳县|612425","岚皋县|612426","平利县|612427","镇坪县|612428","旬阳县|612429","白河县|612430"});
        map.put("0_26_7", new String[]{"市辖区|610201","城区|610202","郊区|610203","耀州区|610204","市区|610220","耀县|610221","宜君县|610222"});
        map.put("0_26_8", new String[]{"市辖区|610301","渭滨区|610302","金台区|610303","陈仓区|610304","市区|610320","宝鸡县|610321","凤翔县|610322","岐山县|610323","扶风县|610324","武功县|610325","眉县|610326","陇县|610327","千阳县|610328","麟游县|610329","凤县|610330","太白县|610331"});
        map.put("0_26_9", new String[]{"市辖区|610401","秦都区|610402","杨陵区|610403","渭城区|610404","兴平县|610421","三原县|610422","泾阳县|610423","乾县|610424","礼泉县|610425","永寿县|610426","彬县|610427","长武县|610428","旬邑县|610429","淳化县|610430","武功县|610431","兴平市|610481"});
        map.put("0_26_10", new String[]{"市辖区|610501","临渭区|610502","华县|610521","潼关县|610522","大荔县|610523","合阳县|610524","澄城县|610525","蒲城县|610526","白水县|610527","富平县|610528","韩城市|610581","华阴市|610582"});
        map.put("0_26_11", new String[]{"市辖区|610601","宝塔区|610602","延长县|610621","延川县|610622","子长县|610623","安塞县|610624","志丹县|610625","吴起县|610626","甘泉县|610627","富县|610628","洛川县|610629","宜川县|610630","黄龙县|610631","黄陵县|610632"});
        map.put("0_26_12", new String[]{"市辖区|610701","汉台区|610702","南郑县|610721","城固县|610722","洋县|610723","西乡县|610724","勉县|610725","宁强县|610726","略阳县|610727","镇巴县|610728","留坝县|610729","佛坪县|610730"});
        map.put("0_26_13", new String[]{"市辖区|610801","榆阳区|610802","神木县|610821","府谷县|610822","横山县|610823","靖边县|610824","定边县|610825","绥德县|610826","米脂县|610827","佳县|610828","吴堡县|610829","清涧县|610830","子洲县|610831"});
        map.put("0_26_14", new String[]{"商州市|612501","洛南县|612522","丹凤县|612523","商南县|612524","山阳县|612525","镇安县|612526","柞水县|612527"});
        map.put("0_26_15", new String[]{"延安市|612601","延长县|612621","延川县|612622","子长县|612623","安塞县|612624","志丹县|612625","吴旗县|612626","甘泉县|612627","富县|612628","洛川县|612629","宜川县|612630","黄龙县|612631","黄陵县|612632","宜君县|612633"});
        map.put("0_26_16", new String[]{"榆林市|612701","榆林县|612721","神木县|612722","府谷县|612723","横山县|612724","靖边县|612725","定边县|612726","绥德县|612727","米脂县|612728","佳县|612729","吴堡县|612730","清涧县|612731","子洲县|612732"});
        map.put("0_26", new String[]{"西安市|610100","安康市|610900","商洛市|611000","渭南地区|612100","咸阳地区|612200","汉中地区|612300","安康地区|612400","铜川市|610200","宝鸡市|610300","咸阳市|610400","渭南市|610500","延安市|610600","汉中市|610700","榆林市|610800","商洛地区|612500","延安地区|612600","榆林地区|612700"});
        map.put("0_27_0", new String[]{"庄浪县|620825","静宁县|620826","市辖区|620801","崆峒区|620802","泾川县|620821","灵台县|620822","崇信县|620823","华亭县|620824"});
        map.put("0_27_1", new String[]{"市辖区|620901","肃州区|620902","金塔县|620921","瓜州县|620922","肃北蒙古族自治县|620923","阿克塞哈萨克族自治县|620924","玉门市|620981","敦煌市|620982"});
        map.put("0_27_2", new String[]{"市辖区|621001","西峰区|621002","庆城县|621021","环县|621022","华池县|621023","合水县|621024","正宁县|621025","宁县|621026","镇原县|621027"});
        map.put("0_27_3", new String[]{"市辖区|621101","安定区|621102","通渭县|621121","陇西县|621122","渭源县|621123","临洮县|621124","漳县|621125","岷县|621126"});
        map.put("0_27_4", new String[]{"市辖区|621201","武都区|621202","成县|621221","文县|621222","宕昌县|621223","康县|621224","西和县|621225","礼县|621226","徽县|621227","两当县|621228"});
        map.put("0_27_5", new String[]{"玉门市|622101","酒泉市|622102","敦煌市|622103","金塔县|622123","肃北蒙古族自治县|622124","阿克塞哈萨克族自治县|622125","安西县|622126"});
        map.put("0_27_6", new String[]{"张掖市|622201","肃南裕固族自治县|622222","民乐县|622223","临泽县|622224","高台县|622225","山丹县|622226"});
        map.put("0_27_7", new String[]{"武威市|622301","民勤县|622322","古浪县|622323","天祝藏族自治县|622326","连古城国家级自然保护区管理局|622327","石羊河林业总场|622328","苏武山林场|622329"});
        map.put("0_27_8", new String[]{"定西县|622421","通渭县|622424","陇西县|622425","渭源县|622426","临洮县|622427","漳县|622428","岷县|622429"});
        map.put("0_27_9", new String[]{"武都县|622621","宕昌县|622623","成县|622624","康县|622625","文县|622626","西和县|622627","礼县|622628","两当县|622629","徽县|622630"});
        map.put("0_27_10", new String[]{"平凉市|622701","泾川县|622722","灵台县|622723","崇信县|622724","华亭县|622725","庄浪县|622726","静宁县|622727"});
        map.put("0_27_11", new String[]{"西峰市|622801","庆阳县|622821","环县|622822","华池县|622823","合水县|622824","正宁县|622825","宁县|622826","镇原县|622827"});
        map.put("0_27_12", new String[]{"临夏市|622901","临夏县|622921","康乐县|622922","永靖县|622923","广河县|622924","和政县|622925","东乡族自治县|622926","积石山保安族东乡族撒拉族自治县|622927"});
        map.put("0_27_13", new String[]{"合作市|623001","临潭县|623021","卓尼县|623022","舟曲县|623023","迭部县|623024","玛曲县|623025","碌曲县|623026","夏河县|623027"});
        map.put("0_27_14", new String[]{"市辖区|620101","城关区|620102","七里河区|620103","西固区|620104","安宁区|620105","红古区|620111","永登县|620121","皋兰县|620122","榆中县|620123"});
        map.put("0_27_15", new String[]{"市辖区|620201","嘉峪关区|620202"});
        map.put("0_27_16", new String[]{"市辖区|620301","金川区|620302","永昌县|620321"});
        map.put("0_27_17", new String[]{"市辖区|620401","白银区|620402","平川区|620403","靖远县|620421","会宁县|620422","景泰县|620423"});
        map.put("0_27_18", new String[]{"市辖区|620501","秦州区|620502","麦积区|620503","清水县|620521","秦安县|620522","甘谷县|620523","武山县|620524","张家川回族自治县|620525"});
        map.put("0_27_19", new String[]{"市辖区|620601","凉州区|620602","民勤县|620621","古浪县|620622","天祝藏族自治县|620623"});
        map.put("0_27_20", new String[]{"市辖区|620701","甘州区|620702","肃南裕固族自治县|620721","民乐县|620722","临泽县|620723","高台县|620724","山丹县|620725"});
        map.put("0_27", new String[]{"平凉市|620800","酒泉市|620900","庆阳市|621000","定西市|621100","陇南市|621200","酒泉地区|622100","张掖地区|622200","武威地区|622300","定西地区|622400","陇南地区|622600","平凉地区|622700","庆阳地区|622800","临夏回族自治州|622900","甘南藏族自治州|623000","兰州市|620100","嘉峪关市|620200","金昌市|620300","白银市|620400","天水市|620500","武威市|620600","张掖市|620700"});
        map.put("0_28_0", new String[]{"市辖区|630101","城东区|630102","城中区|630103","城西区|630104","城北区|630105","大通回族土族自治县|630121","湟中县|630122","湟源县|630123"});
        map.put("0_28_1", new String[]{"共和县|632521","同德县|632522","贵德县|632523","兴海县|632524","贵南县|632525"});
        map.put("0_28_2", new String[]{"玛沁县|632621","班玛县|632622","甘德县|632623","达日县|632624","久治县|632625","玛多县|632626","班玛县|632632"});
        map.put("0_28_3", new String[]{"玉树县|632721","杂多县|632722","称多县|632723","治多县|632724","囊谦县|632725","曲麻莱县|632726"});
        map.put("0_28_4", new String[]{"格尔木市|632801","德令哈市|632802","乌兰县|632821","都兰县|632822","天峻县|632823","大柴旦行委|632824","冷湖行委|632825","茫崖行委|632826"});
        map.put("0_28_5", new String[]{"平安县|632121","民和回族土族自治县|632122","乐都县|632123","湟中县|632124","湟源县|632125","互助土族自治县|632126","化隆回族自治县|632127","循化撒拉族自治县|632128"});
        map.put("0_28_6", new String[]{"门源回族自治县|632221","祁连县|632222","海晏县|632223","刚察县|632224"});
        map.put("0_28_7", new String[]{"同仁县|632321","尖扎县|632322","泽库县|632323","河南蒙古族自治县|632324"});
        map.put("0_28", new String[]{"西宁市|630100","海南藏族自治州|632500","果洛藏族自治州|632600","玉树藏族自治州|632700","海西蒙古族藏族自治州|632800","海东地区|632100","海北藏族自治州|632200","黄南藏族自治州|632300"});
        map.put("0_29_0", new String[]{"市辖区|640101","城区|640102","新城区|640103","兴庆区|640104","西夏区|640105","金凤区|640106","郊区|640111","永宁县|640121","贺兰县|640122","灵武市|640181"});
        map.put("0_29_1", new String[]{"市辖区|640201","大武口区|640202","石嘴山区|640203","石炭井区|640204","惠农区|640205","郊区|640211","市区|640220","平罗县|640221","陶乐县|640222","惠农县|640223"});
        map.put("0_29_2", new String[]{"市辖区|640301","利通区|640302","中卫县|640321","中宁县|640322","盐池县|640323","同心县|640324","青铜峡市|640381","灵武市|640382"});
        map.put("0_29_3", new String[]{"市辖区|640401","原州区|640402","海原县|640421","西吉县|640422","隆德县|640423","泾源县|640424","彭阳县|640425"});
        map.put("0_29_4", new String[]{"市辖区|640501","沙坡头区|640502","中宁县|640521","海原县|640522"});
        map.put("0_29_5", new String[]{"吴忠市|642101","利通区|642102","灵武市|642103","吴忠县|642121","青铜峡县|642122","中卫县|642123","中宁县|642124","灵武县|642125","盐池县|642126","同心县|642127"});
        map.put("0_29_6", new String[]{"固原县|642221","海原县|642222","西吉县|642223","隆德县|642224","泾源县|642225","彭阳县|642226"});
        map.put("0_29", new String[]{"银川市|640100","石嘴山市|640200","吴忠市|640300","固原市|640400","中卫市|640500","吴忠市|642100","固原地区|642200"});
        map.put("0_30_0", new String[]{"市辖区|650101","天山区|650102","沙依巴克区|650103","新市区|650104","水磨沟区|650105","头屯河区|650106","南山矿区|650107","东山区|650108","乌鲁木齐县|650121"});
        map.put("0_30_1", new String[]{"市辖区|650201","独山子区|650202","克拉玛依区|650203","白碱滩区|650204","乌尔禾区|650205"});
        map.put("0_30_2", new String[]{"吐鲁番市|652101","鄯善县|652122","托克逊县|652123"});
        map.put("0_30_3", new String[]{"哈密市|652201","巴里坤哈萨克自治县|652222","伊吾县|652223"});
        map.put("0_30_4", new String[]{"昌吉市|652301","阜康市|652302","米泉市|652303","米泉市|652322","呼图壁县|652323","玛纳斯县|652324","奇台县|652325","阜康市|652326","吉木萨尔县|652327","木垒哈萨克自治县|652328"});
        map.put("0_30_5", new String[]{"伊宁市|652401","奎屯市|652402","伊宁县|652421","察布查尔锡伯自治县|652422","霍城县|652423","巩留县|652424","新源县|652425","昭苏县|652426","特克斯县|652427","尼勒克县|652428"});
        map.put("0_30_6", new String[]{"塔城县|652521","额敏县|652522","乌苏市|652523","沙湾县|652524","托里县|652525","裕民县|652526","和布克赛尔蒙古自治县|652527"});
        map.put("0_30_7", new String[]{"阿勒泰县|652601","布尔津县|652622","富蕴县|652623","福海县|652624","哈巴河县|652625","青河县|652626","吉木乃县|652627"});
        map.put("0_30_8", new String[]{"富蕴县|654322","福海县|654323","哈巴河县|654324","青河县|654325","吉木乃县|654326","阿勒泰市|654301","布尔津县|654321"});
        map.put("0_30_9", new String[]{"石河子市|659001","阿拉尔市|659002","图木舒克市|659003","五家渠市|659004"});
        map.put("0_30_10", new String[]{"博乐市|652701","博乐县|652721","精河县|652722","温泉县|652723"});
        map.put("0_30_11", new String[]{"库尔勒市|652801","库尔勒县|652821","轮台县|652822","尉犁县|652823","若羌县|652824","且末县|652825","焉耆回族自治县|652826","和静县|652827","和硕县|652828","博湖县|652829"});
        map.put("0_30_12", new String[]{"阿克苏市|652901","阿克苏县|652921","温宿县|652922","库车县|652923","沙雅县|652924","新和县|652925","拜城县|652926","乌什县|652927","阿瓦提县|652928","柯坪县|652929"});
        map.put("0_30_13", new String[]{"阿图什市|653001","阿图什县|653021","阿克陶县|653022","阿合奇县|653023","乌恰县|653024"});
        map.put("0_30_14", new String[]{"喀什市|653101","疏附县|653121","疏勒县|653122","英吉沙县|653123","泽普县|653124","莎车县|653125","叶城县|653126","麦盖提县|653127","岳普湖县|653128","伽师县|653129","巴楚县|653130","塔什库尔干塔吉克自治县|653131"});
        map.put("0_30_15", new String[]{"和田市|653201","和田县|653221","墨玉县|653222","皮山县|653223","洛浦县|653224","策勒县|653225","于田县|653226","民丰县|653227"});
        map.put("0_30_16", new String[]{"奎屯市|654001","伊宁市|654002","奎屯市|654003","伊宁县|654021","察布查尔锡伯自治县|654022","霍城县|654023","巩留县|654024","新源县|654025","昭苏县|654026","特克斯县|654027","尼勒克县|654028"});
        map.put("0_30_17", new String[]{"伊宁市|654101","伊宁县|654121","察布查尔锡伯自治县|654122","霍城县|654123","巩留县|654124","新源县|654125","昭苏县|654126","特克斯县|654127","尼勒克县|654128"});
        map.put("0_30_18", new String[]{"塔城市|654201","乌苏市|654202","额敏县|654221","乌苏市|654222","沙湾县|654223","托里县|654224","裕民县|654225","和布克赛尔蒙古自治县|654226"});
        map.put("0_30", new String[]{"乌鲁木齐市|650100","克拉玛依市|650200","吐鲁番地区|652100","哈密地区|652200","昌吉回族自治州|652300","伊犁哈萨克自治州|652400","塔城地区|652500","阿勒泰地区|652600","阿勒泰地区|654300","省直辖行政单位|659000","博尔塔拉蒙古自治州|652700","巴音郭楞蒙古自治州|652800","阿克苏地区|652900","克孜勒苏柯尔克孜自治州|653000","喀什地区|653100","和田地区|653200","伊犁哈萨克自治州|654000","伊犁地区|654100","塔城地区|654200"});
        map.put(PROVINCE_KEY, new String[]{"北京市|110000","天津市|120000","河北省|130000","山西省|140000","内蒙古|150000","辽宁省|210000","吉林省|220000","黑龙江省|230000","上海市|310000","江苏省|320000","浙江省|330000","安徽省|340000","福建省|350000","江西省|360000","山东省|370000","河南省|410000","湖北省|420000","湖南省|430000","广东省|440000","广西|450000","海南省|460000","重庆市|500000","四川省|510000","贵州省|520000","云南省|530000","西藏|540000","陕西省|610000","甘肃省|620000","青海省|630000","宁夏|640000","新疆|650000","台湾省|830000","香港|810000","澳门|820000"});
    }

}