/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.utils;

/**
 * 身份证信息
 *
 * @author Jaemon
 * @version 1.0
 */
public class IdCard {
    /** 身份证号 */
    private String idNo;
    /** 行政区信息 */
    private Canton canton;

    private IdCard(String idNo, Canton canton) {
        this.idNo = idNo;
        this.canton = canton;
    }

    public static IdCard idCard(String idNo, Canton canton) {
        return new IdCard(idNo, canton);
    }

    public String idNo() {
        return idNo;
    }

    public Canton canton() {
        return canton;
    }
}