/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.utils;

/**
 * 户籍所在地
 *
 * @author Jaemon
 * @version 1.0
 */
public class DomicilePlace {
    /** 行政区码 */
    private String code;
    /** 行政区 */
    private Canton canton;

    private DomicilePlace(String code, Canton canton) {
        this.code = code;
        this.canton = canton;
    }

    public static DomicilePlace domicilePlace(String code, Canton canton) {
        return new DomicilePlace(code, canton);
    }

    public String code() {
        return code;
    }

    public Canton canton() {
        return canton;
    }
}