/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.utils;

/**
 * 行政区
 *
 * @author Jaemon
 * @version 1.0
 */
public class Canton {
    /** 省份 */
    private String province;
    /** 地区城市 */
    private String city;
    /** 县市 */
    private String region;

    protected Canton() {
    }

    private Canton(String province, String city, String region) {
        this.province = province;
        this.city = city;
        this.region = region;
    }

    public static Canton canton(String province, String city, String region) {
        return new Canton(province, city, region);
    }

    @Override
    public String toString() {
        return toString("");
    }

    public String toString(String seperator) {
        StringBuilder name = new StringBuilder();
        boolean cityEmpty = StringUtils.isNotEmpty(city);
        boolean regionEmpty = StringUtils.isNotEmpty(region);
        if (StringUtils.isNotEmpty(province)) {
            name.append(province).append(cityEmpty ? seperator : "");
        }

        if (cityEmpty) {
            name.append(city).append(regionEmpty ? seperator : "");
        }

        if (regionEmpty) {
            name.append(region);
        }
        return name.length() == 0 ? "" : name.toString();
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }
}