/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.template.clazz;


import io.gitee.jaemon.mocker.template.AbstractClassGenerator;
import io.gitee.jaemon.mocker.template.ClassGeneratorContext;
import io.gitee.jaemon.mocker.entity.eunms.TemplateType;

/**
 * 拼接式服务层接口实现类生成器
 *
 * @author Jaemon
 * @since 1.0
 */
public class ServiceImplGenerator extends AbstractClassGenerator {

    @Override
    public String frame(ClassGeneratorContext context) {
        String basePackage = context.getBasePackage();
        String upperCamel = context.getUpperCamel();
        String frame = "package " + basePackage + "." + TemplateType.SERVICEIMPL.pkgName() + ";\n\n" +
                "import " + basePackage + "." + TemplateType.ENTITY.pkgName() + "." + upperCamel + ";\n" +
                "import " + basePackage + "." + TemplateType.SERVICE.pkgName() + "." + context.serviceUc() + ";\n" +
                "import " + basePackage + "." + TemplateType.DAO.pkgName() + "." + context.daoUc() + ";\n" +
                "import org.springframework.beans.factory.annotation.Autowired;\n" +
                "import org.springframework.stereotype.Service;\n" +
                "import java.util.List;\n\n" +
                String.format(TYPE_NOTES, upperCamel + "接口实现层") +
                "@Service\n" +
                "public class " + context.serviceImplUc() + " implements " + context.serviceUc() +" {\n" +
                "%s" +
                "}\n";
        return frame;
    }

    @Override
    protected String body(ClassGeneratorContext context) {
        String prefix = "\t@Autowired\n\t" +
                "private " + context.mapperUc() + " " + context.mapperLc() + ";\n";
        return prefix + super.body(context);
    }

    @Override
    public String queryList(ClassGeneratorContext context) {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return "public List<" + context.getUpperCamel() + "> "+ methodName +"() {\n\t\t" +
                "return " + context.mapperLc() + "." + methodName + "();\n\t" +
                "}";
    }

    @Override
    public String queryByPrimaryKey(ClassGeneratorContext context) {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        StringBuilder params = primaryKeysGenerator(context.getPrimaryKeys());
        if (params.length() == 0) {
            return null;
        }

        String queryByPrimaryKey = "public " + context.getUpperCamel() + " "+ methodName +"(%s) {\n\t\t" +
                "return " + context.mapperLc() + "." + methodName + "(" + context.primaryKeyNames() + ");\n\t" +
                "}";
        return String.format(queryByPrimaryKey, params);
    }

    @Override
    public String insert(ClassGeneratorContext context) {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return "public int "+ methodName +"(" + context.getUpperCamel() + " e) {\n\t\t" +
                "return " + context.mapperLc() + "."+ methodName +"(e);\n\t" +
                "}";
    }

    @Override
    public String batchInsert(ClassGeneratorContext context) {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return "public int " + methodName + "(List<" + context.getUpperCamel() + "> list) {\n\t\t" +
                "return " + context.mapperLc() + "."+ methodName +"(list);\n\t" +
                "}";
    }

    @Override
    public String update(ClassGeneratorContext context) {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return "public int " + methodName + "(" + context.getUpperCamel() + " e) {\n\t\t" +
                "return " + context.mapperLc() + "."+ methodName +"(e);\n\t" +
                "}";
    }

    @Override
    public String deleteByPrimaryKey(ClassGeneratorContext context) {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        StringBuilder params = primaryKeysGenerator(context.getPrimaryKeys());
        if (params.length() == 0) {
            return null;
        }
        return String.format("public int " + methodName + "(%s) {\n\t\t" +
                "return " + context.mapperLc() + "." + methodName + "(" + context.primaryKeyNames() + ");\n\t" +
                "}", params);
    }

    @Override
    public boolean notes() {
        return false;
    }

    @Override
    public boolean override() {
        return true;
    }
}