/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.template.clazz;

import io.gitee.jaemon.mocker.common.Constants;
import io.gitee.jaemon.mocker.entity.TemplateColumn;
import io.gitee.jaemon.mocker.entity.eunms.TemplateType;
import io.gitee.jaemon.mocker.template.ClassGenerator;
import io.gitee.jaemon.mocker.template.ClassGeneratorContext;
import io.gitee.jaemon.mocker.template.DataBaseDataType;
import io.gitee.jaemon.mocker.utils.StringUtils;

import java.util.List;

/**
 * 拼接式表对应实体类生成器
 *
 * @author Jaemon
 * @since 1.0
 */
public class ModelGenerator extends ClassGenerator {

    @Override
    public String generator(ClassGeneratorContext context) {
        String basePackage = context.getBasePackage();
        String upperCamel = context.getUpperCamel();
        String frame = "package " + basePackage + "." + TemplateType.ENTITY.pkgName() + ";\n\n" +
                "import java.util.Date;\n\n" +
                String.format(TYPE_NOTES, upperCamel + "实体") +
                "public class " + context.getUpperCamel() + " {\n" +
                "%s" +
                "}\n";
        return String.format(frame, body(context.getColumns()));
    }


    private String body(List<TemplateColumn> columns) {
        StringBuilder body = new StringBuilder();
        StringBuilder fieldBody = new StringBuilder();
        StringBuilder methodBody = new StringBuilder();

        String getFormat = "\tpublic %s get%s() {\n\t\treturn %s;\n\t}\n\n";
        String setFormat = "\tpublic void set%s(%s %s) {\n\t\tthis.%s = %s;\n\t}\n\n";

        columns.forEach(column -> {
            String lowerCamelName = Constants.LOWER_UNDERSCORE_CAMEL_CONVERT.convert(column.getColumnName());
            String upperCamelName = Constants.UPPER_UNDERSCORE_CAMEL_CONVERT.convert(column.getColumnName());
            DataBaseDataType dataBaseDataType = DataBaseDataType.matching(column.getColumnType());
            String columnComment = column.getColumnComment();
            columnComment = StringUtils.isEmpty(columnComment) ? lowerCamelName : columnComment;
            String columnType = column.isNullable() ? dataBaseDataType.packType() : dataBaseDataType.baseType();
            fieldBody
                    .append("\t/** " + columnComment + " */\n\t")
                    .append("private ").append(columnType).append(" ").append(lowerCamelName).append(";\n\n");

            methodBody
                    .append(String.format(getFormat, columnType, upperCamelName, lowerCamelName))
                    .append(String.format(setFormat, upperCamelName, columnType, lowerCamelName, lowerCamelName, lowerCamelName));
        });

        return body.append(fieldBody).append("\n\n").append(methodBody).toString();
    }

}