/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.template.clazz;

import io.gitee.jaemon.mocker.template.AbstractClassGenerator;
import io.gitee.jaemon.mocker.template.ClassGeneratorContext;
import io.gitee.jaemon.mocker.entity.eunms.TemplateType;

/**
 * 拼接式数据库访问层类生成器
 *
 * @author Jaemon
 * @since 1.0
 */
public class DaoGenerator extends AbstractClassGenerator {

    @Override
    public String frame(ClassGeneratorContext context) {
        String basePackage = context.getBasePackage();
        String upperCamel = context.getUpperCamel();
        String frame = "package " + basePackage + "." + TemplateType.DAO.pkgName() + ";\n\n" +
                "import " + basePackage + "." + TemplateType.ENTITY.pkgName() + "." + upperCamel + ";\n" +
                "import org.apache.ibatis.annotations.Param;\n" +
                "import java.util.List;\n\n" +
                String.format(TYPE_NOTES, upperCamel + "数据访问层") +
                "public interface " + context.daoUc() + " {\n" +
                "%s" +
                "}\n";
        return frame;
    }

    @Override
    public String queryList(ClassGeneratorContext context) {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return "List<" + context.getUpperCamel() + "> "+ methodName +"();";
    }

    @Override
    public String queryByPrimaryKey(ClassGeneratorContext context) {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        StringBuilder params = primaryKeysGenerator(context.getPrimaryKeys(), true);
        if (params.length() == 0) {
            return null;
        }

        String queryByPrimaryKey = context.getUpperCamel() + " "+ methodName +"(%s);";
        return String.format(queryByPrimaryKey, params);
    }

    @Override
    public String insert(ClassGeneratorContext context) {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return "int "+ methodName +"(" + context.getUpperCamel() + " e);";
    }

    @Override
    public String batchInsert(ClassGeneratorContext context) {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return "int "+ methodName +"(@Param(\""+ context.getLowerCamel() +"s\") List<" + context.getUpperCamel() + "> list);";
    }

    @Override
    public String update(ClassGeneratorContext context) {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return "int "+ methodName +"(" + context.getUpperCamel() + " e);";
    }

    @Override
    public String deleteByPrimaryKey(ClassGeneratorContext context) {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        StringBuilder params = primaryKeysGenerator(context.getPrimaryKeys(), true);
        if (params.length() == 0) {
            return null;
        }
        return String.format("int "+ methodName +"(%s);", params);
    }
}