/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.template;

import io.gitee.jaemon.mocker.entity.TemplateColumn;
import io.gitee.jaemon.mocker.core.SqlExecutor;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * MySqlTemplateGenerator
 *
 * @author Jaemon
 * @since 1.0
 */
public class MySqlTemplateGenerator extends AbstractTemplateGenerator {
    @Override
    Map<String, List<TemplateColumn>> tables(List<String> tables) {
        List<TemplateColumn> dbAllColumns = SqlExecutor.dbAllColumns(tables);

        return dbAllColumns.stream()
                .collect(Collectors.groupingBy(e -> e.getTableName()));
    }
}