/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.template;

import java.lang.annotation.*;

/**
 * 方法定义
 *
 * @author Jaemon
 * @version 1.0
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface MethodGenerator {
    /**
     * 方法注释
     *
     * @return
     *      注释名称
     */
    String value();

    /**
     * 方法返回值注释
     *
     * @return
     *      注释名称
     */
    String result();

    /**
     * 是否带主键参数
     *
     * @return
     *      true | false
     */
    boolean primaryKeyParam() default false;

    /**
     * 优先级序号
     *
     * @return
     *      序号
     */
    int order() default Integer.MIN_VALUE;

    /**
     * 形参信息
     *
     * @return
     *      true | false
     */
    ParamsNote[] paramsNote() default {};


    @interface ParamsNote {
        /**
         * 参数名
         *
         * @return
         *      参数名
         */
        String name();

        /**
         * 参数描述
         *
         * @return
         *      参数描述
         */
        String desc();
    }
}