/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.template;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 数据库字段类型和java属性类型映射关系
 *
 * @author Jaemon
 * @since 1.0
 */
public enum DataBaseDataType {
    TINYINT("byte", "Byte", Byte.class),
    ENUM("byte", "Byte", Byte.class),
    SMALLINT("short", "Short", Short.class),
    INT("int", "Integer", Integer.class),
    BIGINT("long", "Long", Long.class),
    FLOAT("float", "Float", Float.class),
    DOUBLE("double", "Double", Double.class),
    DECIMAL("double", "BigDecimal", BigDecimal.class),
    CHAR("String", "String", String.class),
    VARCHAR("String", "String", String.class),
    DATE("Date", "Date", Date.class),
    DATETIME("Date", "Date", Date.class),
    TIME("long", "long", Long.class),
    TIMESTAMP("long", "long", Long.class),
    TEXT("String", "String", String.class),
    LONGTEXT("String", "String", String.class),
    MEDIUMTEXT("String", "String", String.class),
    JSON("String", "String", String.class),
    SET("String", "String", String.class),
    BINARY("String", "String", String.class),
    VARBINARY("String", "String", String.class),
    BLOB("String", "String", String.class),
    MEDIUMBLOB("String", "String", String.class),
    LONGBLOB("String", "String", String.class)
    ;

    private String baseType;
    private String packType;
    private Class<?> classType;

    DataBaseDataType(String baseType, String packType, Class<?> classType) {
        this.baseType = baseType;
        this.packType = packType;
        this.classType = classType;
    }

    public String baseType() {
        return baseType;
    }

    public String packType() {
        return packType;
    }

    public Class<?> classType() {
        return classType;
    }

    public static DataBaseDataType matching(String type) {
        for (DataBaseDataType dataBaseDataType : DataBaseDataType.values()) {
            if (dataBaseDataType.name().equals(type.toUpperCase())) {
                return dataBaseDataType;
            }
        }
        return DataBaseDataType.VARCHAR;
    }

}