/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.template;


import io.gitee.jaemon.mocker.entity.TemplateColumn;
import io.gitee.jaemon.mocker.core.TemplateContext;

import java.util.List;
import java.util.stream.Collectors;

/**
 * ClassGeneratorContext
 *
 * @author Jaemon
 * @since 1.0
 */
public class ClassGeneratorContext {
    /** 表名 */
    private String tableName;
    /** 主键 */
    private List<PrimaryKey> primaryKeys;
    /** UserInfo */
    private String upperCamel;
    /** userInfo */
    private String lowerCamel;
    /** 表列信息 */
    private List<TemplateColumn> columns;

    private TemplateContext template;

    public String serviceLc() {
        return lowerCamel + template.getService();
    }
    public String serviceUc() {
        return upperCamel + template.getService();
    }

    public String serviceImplLc() {
        return lowerCamel + template.getServiceImpl();
    }
    public String serviceImplUc() {
        return upperCamel + template.getServiceImpl();
    }

    public String daoLc() {
        return lowerCamel + template.getDao();
    }
    public String daoUc() {
        return upperCamel + template.getDao();
    }

    public String mapperLc() {
        return lowerCamel + template.getMapper();
    }
    public String mapperUc() {
        return upperCamel + template.getMapper();
    }


    public String getBasePackage() {
        return template.getBasePackage();
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<PrimaryKey> getPrimaryKeys() {
        return primaryKeys;
    }

    public String primaryKeyNames() {
        if (primaryKeys == null) {
            return "";
        }
        return primaryKeys.stream().map(PrimaryKey::getName).collect(Collectors.joining(", "));
    }

    public void setPrimaryKeys(List<PrimaryKey> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public String getUpperCamel() {
        return upperCamel;
    }

    public void setUpperCamel(String upperCamel) {
        this.upperCamel = upperCamel;
    }

    public String getLowerCamel() {
        return lowerCamel;
    }

    public void setLowerCamel(String lowerCamel) {
        this.lowerCamel = lowerCamel;
    }

    public List<TemplateColumn> getColumns() {
        return columns;
    }

    public void setColumns(List<TemplateColumn> columns) {
        this.columns = columns;
    }

    public TemplateContext getTemplate() {
        return template;
    }

    public void setTemplate(TemplateContext template) {
        this.template = template;
    }

    public static class PrimaryKey {
        /** 主键类型 */
        private String type;
        /** 主键列名 */
        private String name;
        /** 字段描述 */
        private String desc;

        public PrimaryKey(String type, String name, String desc) {
            this.type = type;
            this.name = name;
            this.desc = desc;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}