/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.template;

import io.gitee.jaemon.mocker.entity.eunms.FileType;

/**
 * 类文件生成器
 *
 * @author Jaemon
 * @since 1.0
 */
public abstract class ClassGenerator {
    private static final String userName = System.getProperty("user.name");
    /** 类注释 */
    protected static final String TYPE_NOTES = "" +
            "/**\n" +
            " * %s\n" +
            " * \n" +
            " * @author " + userName + " \n" +
            " */ \n";

    public ClassGenerator() {
        register();
    }

    /**
     * 生成类文件
     *
     * @param context
     *      上下文信息
     * @return
     *      类文件字符串
     */
    public abstract String generator(ClassGeneratorContext context);

    /**
     * 是否需要带注释
     *
     * @return
     *      true | false
     */
    public boolean notes() {
        return true;
    }

    /**
     * 是否需要重写标志
     *
     * @return
     *      true | false
     */
    public boolean override() {
        return false;
    }

    /**
     * 文件后缀类型
     *
     * @return
     *      {@link FileType}
     */
    public FileType suffix() {
        return FileType.JAVA;
    }

    /**
     * 注册当前实例对象
     */
    public void register() {
        TemplateGeneratorFactory.classGeneratorHashMap.put(this.getClass().getName(), this);
    }
}