/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.template;


/**
 * 类文件方法定义
 *
 * @author Jaemon
 * @since 1.0
 */
public abstract class AbstractClassMethods extends ClassGenerator {

    /**
     * 查询列表方法体声明
     *
     * @param context
     *      上下文信息
     * @return
     *      方法体字符串
     */
    @MethodGenerator(value = "查询列表", result = "查询结果列表", order = 1)
    protected abstract String queryList(ClassGeneratorContext context);

    /**
     * 根据主键查询方法体声明
     *
     * @param context
     *      上下文信息
     * @return
     *      方法体字符串
     */
    @MethodGenerator(value = "根据主键查询", result = "查询结果", primaryKeyParam = true, order = 2)
    protected abstract String queryByPrimaryKey(ClassGeneratorContext context);

    /**
     * 新增一条记录方法体声明
     *
     * @param context
     *      上下文信息
     * @return
     *      方法体字符串
     */
    @MethodGenerator(value = "新增一条记录", result = "影响条数", paramsNote = {
            @MethodGenerator.ParamsNote(name = "e", desc = "记录")
    }, order = 3)
    protected abstract String insert(ClassGeneratorContext context);

    /**
     * 批量新增记录方法体声明
     *
     * @param context
     *      上下文信息
     * @return
     *      方法体字符串
     */
    @MethodGenerator(value = "批量新增记录", result = "影响条数", paramsNote = {
            @MethodGenerator.ParamsNote(name = "list", desc = "记录列表")
    }, order = 4)
    protected abstract String batchInsert(ClassGeneratorContext context);

    /**
     * 更新记录方法体声明
     *
     * @param context
     *      上下文信息
     * @return
     *      方法体字符串
     */
    @MethodGenerator(value = "更新记录", result = "影响条数", paramsNote = {
            @MethodGenerator.ParamsNote(name = "e", desc = "记录")
    }, order = 5)
    protected abstract String update(ClassGeneratorContext context);

    /**
     * 删除一条记录方法体声明
     *
     * @param context
     *      上下文信息
     * @return
     *      方法体字符串
     */
    @MethodGenerator(value = "根据主键删除记录", result = "影响条数", primaryKeyParam = true, order = 6)
    protected abstract String deleteByPrimaryKey(ClassGeneratorContext context);
}