/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.function;

import io.gitee.jaemon.mocker.entity.MockData;

/**
 * Function
 *
 * @author Jaemon
 * @since 1.0
 */
@FunctionalInterface
public interface Function<R> {

    /**
     * 执行函数
     *
     * @param index
     *      当前记录索引
     * @param mockData
     *      mock数据实体
     * @return
     *      R
     */
    R execute(int index, MockData mockData);
}